% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{hi_solver_set_option}
\alias{hi_solver_set_option}
\title{Set a HiGHS Solver Option}
\usage{
hi_solver_set_option(
  solver,
  key,
  value,
  type = c("auto", "bool", "integer", "double", "string")
)
}
\arguments{
\item{solver}{A HiGHS solver object of class \code{"highs_solver"}.}

\item{key}{A character string specifying the option name to set.}

\item{value}{The value to set for the specified option. Will be coerced to the appropriate type.}

\item{type}{Type of the option. Can be one of "auto", "bool", "integer", "double", or "string".
When set to "auto" (default), the function will attempt to determine the type from the available options list.
Specify a type directly if the option is valid but not listed in the available options.}
}
\value{
Invisibly returns NULL.
}
\description{
Sets the value of a specific option for a HiGHS solver instance.
}
\examples{
solver <- example_solver()
hi_solver_set_option(solver, "output_flag", "FALSE")
hi_solver_set_option(solver, "solver", "simplex", type = "string")

}
