% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_plot.R
\name{classPlot}
\alias{classPlot}
\title{Plot item bars grouped by class}
\usage{
classPlot(
  df,
  title = "Class plot",
  xLab = "Value",
  yLab = "Item",
  legendLab = "Class",
  palette = "Spectral",
  labelSize = 2.5,
  labelColor = "black",
  decreasing = TRUE,
  valueCutoff = 0,
  ...
)
}
\arguments{
\item{df}{A data frame with at least three columns, with class, item and
value as the first three columns. The latter must be numeric.}

\item{title}{Plot title.}

\item{xLab}{Label of x axis.}

\item{yLab}{Label of y axis.}

\item{legendLab}{Legend label.}

\item{palette}{grDevices palette.}

\item{labelSize}{Label size. Ignored if \code{labelDF} is \code{NULL}.}

\item{labelColor}{Label color.}

\item{decreasing}{Whether to display the bars in decreasing order of length.}

\item{valueCutoff}{Cutoff used for filtering the input data frame based on
the value column. Only values greater than this cutoff will be displayed on
the plot.}

\item{...}{Other arguments passed to \code{centerTitle}.}
}
\value{
An object of class \code{gg}.
}
\description{
This function plots bars for each item while grouping them by class and
ordering them.
}
\examples{
 df <- data.frame(Class = sample(paste0('C', seq(13)), 25, replace=TRUE),
 Item = paste0('I', seq(25)),
 Value = runif(25, 0.5, 1))
 classPlot(df)

 df <- data.frame(Class = sample(paste0('C', seq(13)), 25, replace=TRUE),
 Item = sample(paste0('I', seq(21)), 25, replace=TRUE),
 Value = runif(25, 0.5, 1))
 classPlot(df)

}
