% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTDest-methods.R
\name{MTDest-methods}
\alias{MTDest-methods}
\alias{print.MTDest}
\alias{summary.MTDest}
\alias{print.summary.MTDest}
\alias{coef.MTDest}
\alias{logLik.MTDest}
\title{Methods for objects of class \code{"MTDest"}}
\usage{
\method{print}{MTDest}(x, ...)

\method{summary}{MTDest}(object, ...)

\method{print}{summary.MTDest}(x, ...)

\method{coef}{MTDest}(object, ...)

\method{logLik}{MTDest}(object, ...)
}
\arguments{
\item{x}{An object of class \code{"MTDest"} or \code{"summary.MTDest"},
depending on the method.}

\item{...}{Further arguments passed to or from other methods (ignored).}

\item{object}{An object of class \code{"MTDest"} (used by methods that operate
on the fitted model).}
}
\value{
\describe{
\item{\code{print.MTDest}}{Invisibly returns the \code{"MTDest"} object, after
displaying its lag set, state space, final log-likelihood, and iteration
count (if available).}
\item{\code{print.summary.MTDest}}{Invisibly returns the \code{"summary.MTDest"} object,
after displaying its contents: lambdas; transition matrices; independent
distribution; log-likelihood; oscillations (if available); and
iteration diagnostics (if available).}
\item{\code{summary.MTDest}}{An object of class \code{"summary.MTDest"}.}
\item{\code{coef.MTDest}}{A list with estimated \code{lambdas}, \code{pj}, and \code{p0}.}
\item{\code{logLik.MTDest}}{ An object of class \code{"logLik"} with attributes
\code{df} (number of free parameters) and \code{nobs} (effective sample size).}
}
}
\description{
Printing method for EM fits of Mixture Transition Distribution (MTD) models.

Summary method for EM fits of MTD models.

Printing method for \code{"summary.MTDest"} objects.

Extract coefficients from an \code{"MTDest"} fit.

Extract log-likelihood from an \code{"MTDest"} fit.
}
\details{
The \code{print.MTDest()} method displays a compact summary of the fitted model:
the lag set (\code{S}), the state space (\code{A}), the final log-likelihood,
and, if available, the number of EM updates performed.

The \code{summary.MTDest()} method collects key fields from an
\code{"MTDest"} object into a compact list (class \code{"summary.MTDest"})
suitable for printing.

The \code{print.summary.MTDest()} method prints that summary in a readable format,
including lambdas, transition matrices, independent distribution,
log-likelihood, oscillations (if available), and iteration diagnostics (if available).

The \code{coef.MTDest()} method returns the fitted mixture weights
(\code{lambdas}), the list of transition matrices (\code{pj}), and (if present)
the independent distribution \code{p0}.

The \code{logLik.MTDest()} computes the log-likelihood and returns an object
of class \code{"logLik"} with attributes: \code{nobs}, the effective sample
size used for estimation, and \code{df}, number of free parameters estimated
supposing all transition matrices pj to be distinct (multimatrix model).
Note: in the returned "logLik" object, \code{df} denotes the number of free
parameters (not residual degrees of freedom).
}
\examples{
set.seed(1)
MTD <- MTDmodel(Lambda = c(1, 3), A = c(0, 1), lam0 = 0.01)
X <- perfectSample(MTD, N = 200)  # small N to keep examples fast
init <- list(
  p0 = c(0.4, 0.6),
  lambdas = c(0.05, 0.45, 0.5),
  pj = list(
    matrix(c(0.2, 0.8, 0.45, 0.55), byrow = TRUE, ncol = 2),
    matrix(c(0.25, 0.75, 0.3, 0.7),  byrow = TRUE, ncol = 2)
  )
)
fit <- MTDest(X, S = c(1, 3), init = init, iter = TRUE)
print(fit)
summary(fit)
coef(fit)
logLik(fit)
BIC(fit)

}
\seealso{
\code{\link{MTDest}}, \code{\link{summary.MTDest}},
\code{\link{print.summary.MTDest}}, \code{\link{coef.MTDest}},
\code{\link{logLik}}, \code{\link{AIC}}, \code{\link{BIC}}
}
