% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\title{Fit B&M model 2 to new data using \code{stats::nls()}}
\usage{
fit_model(temp, days, species = NULL, development_type = NULL)
}
\arguments{
\item{temp}{Numeric vector of temperatures}

\item{days}{Numeric vector of days to hatch or emerge}

\item{species}{Character string of species name (e.g., "sockeye")}

\item{development_type}{Character string of development type: "hatch"
or "emerge"}
}
\value{
List with fit model object, model coefficients, model specifications
data.frame, and plot of observations and model fit.
}
\description{
Generate your own custom parameterized models for predicting hatching
and emergence phenology.
}
\details{
\strong{hatchR} also includes functionality to generate your own custom
parameterized models for predicting hatching and emergence phenology.
Importantly, the custom parameterization relies on the model format
developed from model 2 of Beacham and Murray (1990), which we chose
because of its overall simplicity and negligible loss of accuracy.
See Beacham and Murray (1990) and Sparks et al. (2019) for more
specific discussion regarding model 2 and the development of the
effective value approach.
}
\examples{
library(hatchR)
# vector of temperatures
temperature <- c(2, 5, 8, 11, 14)
# vector of days to hatch
days_to_hatch <- c(194, 87, 54, 35, 28)
bt_hatch_mod <- fit_model(
  temp = temperature,
  days = days_to_hatch, species = "sockeye", development_type = "hatch"
)
}
