% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.ipw_haldensify}
\alias{confint.ipw_haldensify}
\title{Confidence Intervals for IPW Estimates of the Causal Effects of Stochatic
Shift Interventions}
\usage{
\method{confint}{ipw_haldensify}(object, parm = seq_len(object$psi), level = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{ipw_haldensify}, produced by invoking
the function \code{\link{ipw_shift}}, for which a confidence interval is to
be computed.}

\item{parm}{A \code{numeric} vector indicating indices of \code{object$est}
for which to return confidence intervals.}

\item{level}{A \code{numeric} indicating the nominal level of the confidence
interval to be computed.}

\item{...}{Other arguments. Not currently used.}
}
\value{
A named \code{numeric} vector containing the parameter estimate from
 a \code{ipw_haldensify} object, alongside lower/upper Wald-style confidence
 intervals at a specified coverage level.
}
\description{
Confidence Intervals for IPW Estimates of the Causal Effects of Stochatic
Shift Interventions
}
\details{
Compute confidence intervals for estimates produced by
 \code{\link{ipw_shift}}.
}
\examples{
# simulate data
n_obs <- 50
W1 <- rbinom(n_obs, 1, 0.6)
W2 <- rbinom(n_obs, 1, 0.2)
A <- rnorm(n_obs, (2 * W1 - W2 - W1 * W2), 2)
Y <- rbinom(n_obs, 1, plogis(3 * A + W1 + W2 - W1 * W2))

# fit the IPW estimator
est_ipw_shift <- ipw_shift(
  W = cbind(W1, W2), A = A, Y = Y,
  delta = 0.5, n_bins = 3L, cv_folds = 2L,
  lambda_seq = exp(seq(-1, -10, length = 100L)),
  # arguments passed to hal9001::fit_hal()
  max_degree = 1,
  # ...continue arguments for IPW
  undersmooth_type = "gcv"
)
confint(est_ipw_shift)
}
