% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_estimate_uncertainties.R
\name{ggplot_estimate_uncertainties}
\alias{ggplot_estimate_uncertainties}
\title{Plots uncertainties in model error estimates}
\usage{
ggplot_estimate_uncertainties(JAB_stats, fill_colour = NULL)
}
\arguments{
\item{JAB_stats}{Required. Data frame of jackknife after boot statistics for a large number
of model runs, as produced by \code{CAMELS_bootjack}.}

\item{fill_colour}{Optional. If \code{NULL} (the default), then all data series are plotted as lines.
If specified, e.g.\code{fill_colour = "orange"}, the plot of 2 x the Jackknife estimate of the
standard error will be filled with the specified colour.}
}
\value{
Returns a \code{ggplot2} object of the plots, faceted by goodness of fit statistic, i.e. NSE/KGE.
The confidence interval (difference between the 95^th^ and 5^th^ quantiles, and the value of
2 x the Bootstrap estimate of the standard error are plotted as lines. The values of
2 x the Jackknife estimate of the standard error are plotted as filled)
}
\description{
Plots uncertainties in model error estimates
}
\examples{
\dontrun{ p <- ggplot_estimate_uncertainties(all_stats, "orange")
}
}
\seealso{
\code{\link{CAMELS_bootjack}}
}
\author{
Martyn Clark and Kevin Shook
}
