% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_stack.R
\name{tbl_stack}
\alias{tbl_stack}
\title{Stack tables}
\usage{
tbl_stack(
  tbls,
  group_header = NULL,
  quiet = FALSE,
  attr_order = seq_along(tbls),
  tbl_ids = NULL
)
}
\arguments{
\item{tbls}{(\code{list})\cr
List of gtsummary objects}

\item{group_header}{(\code{character})\cr
Character vector with table headers where length matches the length of \code{tbls}}

\item{quiet}{(scalar \code{logical})\cr
Logical indicating whether to suppress additional messaging. Default is \code{FALSE}.}

\item{attr_order}{(\code{integer}) \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} \cr
Set the order table attributes are set.
Tables are stacked in the order they are passed in the \code{tbls} argument:
use \code{attr_order} to specify the order the table attributes take precedent.
For example, to use the header from the second table specify \code{attr_order=2}.
Default is to set precedent in the order tables are passed.}

\item{tbl_ids}{(\code{character})\cr
Optional character vector of IDs that will be assigned to the input tables.
The ID is assigned by assigning a name to the \code{tbls} list, which is
returned in \code{x$tbls}.}
}
\value{
A \code{tbl_stack} object
}
\description{
Assists in patching together more complex tables. \code{tbl_stack()} appends two
or more gtsummary tables.
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed("cardx") && gtsummary:::is_pkg_installed("survival", ref = "cardx")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
# stacking two tbl_regression objects
t1 <-
  glm(response ~ trt, trial, family = binomial) \%>\%
  tbl_regression(
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (unadjusted)")
  )

t2 <-
  glm(response ~ trt + grade + stage + marker, trial, family = binomial) \%>\%
  tbl_regression(
    include = "trt",
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (adjusted)")
  )

tbl_stack(list(t1, t2))

# Example 2 ----------------------------------
# stacking two tbl_merge objects
library(survival)
t3 <-
  coxph(Surv(ttdeath, death) ~ trt, trial) \%>\%
  tbl_regression(
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (unadjusted)")
  )

t4 <-
  coxph(Surv(ttdeath, death) ~ trt + grade + stage + marker, trial) \%>\%
  tbl_regression(
    include = "trt",
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (adjusted)")
  )

# first merging, then stacking
row1 <- tbl_merge(list(t1, t3), tab_spanner = c("Tumor Response", "Death"))
row2 <- tbl_merge(list(t2, t4))

tbl_stack(list(row1, row2), group_header = c("Unadjusted Analysis", "Adjusted Analysis"))
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
