% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_hierarchical.R
\name{tbl_hierarchical}
\alias{tbl_hierarchical}
\alias{tbl_hierarchical_count}
\title{Hierarchical Table}
\usage{
tbl_hierarchical(
  data,
  variables,
  id,
  denominator,
  by = NULL,
  include = everything(),
  statistic = everything() ~ "{n} ({p}\%)",
  overall_row = FALSE,
  label = NULL,
  digits = NULL
)

tbl_hierarchical_count(
  data,
  variables,
  denominator = NULL,
  by = NULL,
  include = everything(),
  overall_row = FALSE,
  statistic = everything() ~ "{n}",
  label = NULL,
  digits = NULL
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
character vector or tidy-selector of columns in \code{data} used to create a hierarchy. Hierarchy will be built with
variables in the order given.}

\item{id}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
argument used to subset \code{data} to identify rows in \code{data} to calculate
event rates in \code{tbl_hierarchical()}.}

\item{denominator}{(\code{data.frame}, \code{integer})\cr
used to define the denominator and enhance the output.
The argument is required for \code{tbl_hierarchical()} and optional for \code{tbl_hierarchical_count()}.
The \code{denominator} argument must be specified when \code{id} is used to calculate event rates.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
a single column from \code{data}. Summary statistics will be stratified by this variable.
Default is \code{NULL}.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns from the \code{variables} argument for which summary statistics should be returned (on the variable label rows).
Including the last element of \code{variables} has no effect since each level has its own row for this variable.
The default is \code{everything()}.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
used to specify the summary statistics to display for all variables in \code{tbl_hierarchical()}.
The default is \code{everything() ~ "{n} ({p})"}.}

\item{overall_row}{(scalar \code{logical})\cr
whether an overall summary row should be included at the top of the table.
The default is \code{FALSE}.}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
used to override default labels in hierarchical table, e.g. \code{list(AESOC = "System Organ Class")}.
The default for each variable is the column label attribute, \code{attr(., 'label')}.
If no label has been set, the column name is used.}

\item{digits}{(\code{\link[=syntax]{formula-list-selector}})\cr
specifies how summary statistics are rounded. Values may be either integer(s) or function(s). If not specified,
default formatting is assigned via \code{label_style_number()} for statistics \code{n} and \code{N}, and
\code{label_style_percent(digits=1)} for statistic \code{p}.}
}
\value{
a gtsummary table of class \code{"tbl_hierarchical"} (for \code{tbl_hierarchical()}) or \code{"tbl_hierarchical_count"}
(for \code{tbl_hierarchical_count()}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
Use these functions to generate hierarchical tables.
\itemize{
\item \code{tbl_hierarchical()}: Calculates \emph{rates} of events (e.g. adverse events)
utilizing the \code{denominator} and \code{id} arguments to identify the rows in \code{data}
to include in each rate calculation. If \code{variables} contains more than one
variable and the last variable in \code{variables} is an ordered factor, then
rates of events by highest level will be calculated.
\item \code{tbl_hierarchical_count()}: Calculates \emph{counts} of events utilizing
all rows for each tabulation.
}
}
\section{Overall Row}{


An overall row can be added to the table as the first row by specifying \code{overall_row = TRUE}. Assuming that each row
in \code{data} corresponds to one event record, this row will count the overall number of events recorded when used in
\code{tbl_hierarchical_count()}, or the overall number of patients recorded with any event when used in
\code{tbl_hierarchical()}.

A label for this overall row can be specified by passing an \code{'..ard_hierarchical_overall..'} element in \code{label}.
Similarly, the rounding for statistics in the overall row can be modified using the \code{digits} argument,
again referencing the \code{'..ard_hierarchical_overall..'} name.
}

\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ADAE_subset <- cards::ADAE |>
  dplyr::filter(
    AESOC \%in\% unique(cards::ADAE$AESOC)[1:5],
    AETERM \%in\% unique(cards::ADAE$AETERM)[1:5]
  )

# Example 1 - Event Rates --------------------
tbl_hierarchical(
  data = ADAE_subset,
  variables = c(AESOC, AETERM),
  by = TRTA,
  denominator = cards::ADSL |> mutate(TRTA = ARM),
  id = USUBJID,
  digits = everything() ~ list(p = 1),
  overall_row = TRUE,
  label = list(..ard_hierarchical_overall.. = "Any Adverse Event")
)

# Example 2 - Rates by Highest Severity ------
tbl_hierarchical(
  data = ADAE_subset |> mutate(AESEV = factor(AESEV, ordered = TRUE)),
  variables = c(AESOC, AESEV),
  by = TRTA,
  id = USUBJID,
  denominator = cards::ADSL |> mutate(TRTA = ARM),
  include = AESEV,
  label = list(AESEV = "Highest Severity")
)

# Example 3 - Event Counts -------------------
tbl_hierarchical_count(
  data = ADAE_subset,
  variables = c(AESOC, AETERM, AESEV),
  by = TRTA,
  overall_row = TRUE,
  label = list(..ard_hierarchical_overall.. = "Total Number of AEs")
)
\dontshow{\}) # examplesIf}
}
