% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_overall_ard.R
\name{add_overall_ard}
\alias{add_overall_ard}
\alias{add_overall.tbl_ard_summary}
\title{ARD add overall column}
\usage{
\method{add_overall}{tbl_ard_summary}(
  x,
  cards,
  last = FALSE,
  col_label = "**Overall**",
  statistic = NULL,
  ...
)
}
\arguments{
\item{x}{(\code{tbl_ard_summary})\cr
A stratified 'gtsummary' table}

\item{cards}{(\code{card})\cr
An ARD object of class \code{"card"} typically created with \verb{cards::ard_*()} functions.}

\item{last}{(scalar \code{logical})\cr
Logical indicator to display overall column last in table.
Default is \code{FALSE}, which will display overall column first.}

\item{col_label}{(\code{string})\cr
String indicating the column label. Default is \code{"**Overall**"}}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
Override the statistic argument in initial \verb{tbl_*} function
call. Default is \code{NULL}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A \code{gtsummary} of same class as \code{x}
}
\description{
Adds a column with overall summary statistics to tables
created by \code{tbl_ard_summary()}.
}
\examples{
# Example 1 ----------------------------------
# build primary table
tbl <-
  cards::ard_stack(
    trial,
    .by = trt,
    cards::ard_continuous(variables = age),
    cards::ard_categorical(variables = grade),
    .missing = TRUE,
    .attributes = TRUE,
    .total_n = TRUE
  ) |>
  tbl_ard_summary(by = trt)

# create ARD with overall results
ard_overall <-
  cards::ard_stack(
    trial,
    cards::ard_continuous(variables = age),
    cards::ard_categorical(variables = grade),
    .missing = TRUE,
    .attributes = TRUE,
    .total_n = TRUE
  )

# add an overall column
tbl |>
  add_overall(cards = ard_overall)
}
\author{
Daniel D. Sjoberg
}
