% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greta_model_class.R
\name{model}
\alias{model}
\alias{print.greta_model}
\alias{plot.greta_model}
\title{greta model objects}
\usage{
model(..., precision = c("double", "single"), compile = TRUE)

\method{print}{greta_model}(x, ...)

\method{plot}{greta_model}(x, y, colour = "#996bc7", ...)
}
\arguments{
\item{\dots}{for \code{model}: \code{greta_array} objects to be tracked by
the model (i.e. those for which samples will be retained during mcmc). If
not provided, all of the non-data \code{greta_array} objects defined in the
calling environment will be tracked. For \code{print} and
\code{plot}:further arguments passed to or from other methods (currently
ignored).}

\item{precision}{the floating point precision to use when evaluating this
model. Switching from \code{"double"} (the default) to \code{"single"} may
decrease the computation time but increase the risk of numerical
instability during sampling.}

\item{compile}{whether to apply
\href{https://openxla.org/xla}{XLA JIT compilation} to
the TensorFlow graph representing the model. This may slow down model
definition, and speed up model evaluation.}

\item{x}{a \code{greta_model} object}

\item{y}{unused default argument}

\item{colour}{base colour used for plotting. Defaults to \code{greta} colours
in violet.}
}
\value{
\code{model} - a \code{greta_model} object.

\code{plot} - a \code{\link[DiagrammeR:grViz]{DiagrammeR::grViz()}}
object, with the
\code{\link[DiagrammeR:create_graph]{DiagrammeR::dgr_graph()}} object used to
create it as an attribute \code{"dgr_graph"}.
}
\description{
Create a \code{greta_model} object representing a statistical
model (using \code{model}), and plot a graphical representation of the
model. Statistical inference can be performed on \code{greta_model} objects
with \code{\link[=mcmc]{mcmc()}}
}
\details{
\code{model()} takes greta arrays as arguments, and defines a
statistical model by finding all of the other greta arrays on which they
depend, or which depend on them. Further arguments to \code{model} can be
used to configure the TensorFlow graph representing the model, to tweak
performance.

The plot method produces a visual representation of the defined
model. It uses the \code{DiagrammeR} package, which must be installed
first. Here's a key to the plots:
\if{html}{\figure{plotlegend.png}{options: width="100\%"}}
\if{latex}{\figure{plotlegend.pdf}{options: width=7cm}}
}
\examples{
\dontrun{

# define a simple model
mu <- variable()
sigma <- normal(0, 3, truncation = c(0, Inf))
x <- rnorm(10)
distribution(x) <- normal(mu, sigma)

m <- model(mu, sigma)

plot(m)
}
}
