% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth-estimates.R
\name{draw.smooth_estimates}
\alias{draw.smooth_estimates}
\title{Plot the result of a call to \code{smooth_estimates()}}
\usage{
\method{draw}{smooth_estimates}(
  object,
  constant = NULL,
  fun = NULL,
  contour = TRUE,
  grouped_by = FALSE,
  contour_col = "black",
  n_contour = NULL,
  ci_alpha = 0.2,
  ci_col = "black",
  smooth_col = "black",
  resid_col = "steelblue3",
  decrease_col = "#56B4E9",
  increase_col = "#E69F00",
  change_lwd = 1.75,
  partial_match = FALSE,
  discrete_colour = NULL,
  discrete_fill = NULL,
  continuous_colour = NULL,
  continuous_fill = NULL,
  angle = NULL,
  ylim = NULL,
  crs = NULL,
  default_crs = NULL,
  lims_method = "cross",
  caption = TRUE,
  ...
)
}
\arguments{
\item{object}{a fitted GAM, the result of a call to \code{\link[mgcv:gam]{mgcv::gam()}}.}

\item{constant}{numeric; a constant to add to the estimated values of the
smooth. \code{constant}, if supplied, will be added to the estimated value
before the confidence band is computed.}

\item{fun}{function; a function that will be applied to the estimated values
and confidence interval before plotting. Can be a function or the name of a
function. Function \code{fun} will be applied after adding any \code{constant}, if
provided.}

\item{contour}{logical; should contours be draw on the plot using
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{grouped_by}{logical; should factor by smooths be drawn as one panel
per level of the factor (\code{FALSE}, the default), or should the individual
smooths be combined into a single panel containing all levels (\code{TRUE})?}

\item{contour_col}{colour specification for contour lines.}

\item{n_contour}{numeric; the number of contour bins. Will result in
\code{n_contour - 1} contour lines being drawn. See \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{ci_alpha}{numeric; alpha transparency for confidence or simultaneous
interval.}

\item{ci_col}{colour specification for the confidence/credible intervals
band. Affects the fill of the interval.}

\item{smooth_col}{colour specification for the smooth line.}

\item{resid_col}{colour specification for the partial residuals.}

\item{decrease_col, increase_col}{colour specifications to use for
indicating periods of change. \code{col_change} is used when
\code{change_type = "change"}, while \code{col_decrease} and \code{col_increase} are used
when `change_type = "sizer"``.}

\item{change_lwd}{numeric; the value to set the \code{linewidth} to in
\code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}, used to represent the periods of change.}

\item{partial_match}{logical; should smooths be selected by partial matches
with \code{select}? If \code{TRUE}, \code{select} can only be a single string to match
against.}

\item{discrete_colour}{a suitable colour scale to be used when plotting
discrete variables.}

\item{discrete_fill}{a suitable fill scale to be used when plotting
discrete variables.}

\item{continuous_colour}{a suitable colour scale to be used when plotting
continuous variables.}

\item{continuous_fill}{a suitable fill scale to be used when plotting
continuous variables.}

\item{angle}{numeric; the angle at which the x axis tick labels are to be
drawn passed to the \code{angle} argument of \code{\link[ggplot2:guide_axis]{ggplot2::guide_axis()}}.}

\item{ylim}{numeric; vector of y axis limits to use all \emph{all} panels drawn.}

\item{crs}{the coordinate reference system (CRS) to use for the plot. All
data will be projected into this CRS. See \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} for
details.}

\item{default_crs}{the coordinate reference system (CRS) to use for the
non-sf layers in the plot. If left at the default \code{NULL}, the CRS used is
4326 (WGS84), which is appropriate for spline-on-the-sphere smooths, which
are parameterized in terms of latitude and longitude as coordinates. See
\code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} for more details.}

\item{lims_method}{character; affects how the axis limits are determined. See
\code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}}. Be careful; in testing of some examples, changing
this to \code{"orthogonal"} for example with the chlorophyll-a example from
Simon Wood's GAM book quickly used up all the RAM in my test system and the
OS killed R. This could be incorrect usage on my part; right now the grid
of points at which SOS smooths are evaluated (if not supplied by the user)
can produce invalid coordinates for the corners of tiles as the grid is
generated for tile centres without respect to the spacing of those tiles.}

\item{caption}{logical; show the smooth type in the caption of each plot?}

\item{...}{additional arguments passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.}
}
\description{
Plot the result of a call to \code{smooth_estimates()}
}
\examples{
load_mgcv()
# example data
df <- data_sim("eg1", seed = 21)
# fit GAM
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = "REML")
# plot all of the estimated smooths
sm <- smooth_estimates(m)
draw(sm)
# evaluate smooth of `x2`
sm <- smooth_estimates(m, select = "s(x2)")
# plot it
draw(sm)

# customising some plot elements
draw(sm, ci_col = "steelblue", smooth_col = "forestgreen", ci_alpha = 0.3)

# Add a constant to the plotted smooth
draw(sm, constant = coef(m)[1])

# Adding change indicators to smooths based on derivatives of the smooth
d <- derivatives(m, n = 100) # n to match smooth_estimates()

smooth_estimates(m) |>
  add_sizer(derivatives = d, type = "sizer") |>
  draw()
}
