% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearmonth-class.R
\name{yearmonth_class}
\alias{yearmonth_class}
\alias{yearmonth}
\alias{as_yearmonth}
\alias{as_yearmonth.default}
\alias{as_yearmonth.Date}
\alias{as_yearmonth.POSIXt}
\alias{as_yearmonth.character}
\alias{as_yearmonth.factor}
\alias{new_yearmonth}
\alias{is_yearmonth}
\title{Yearmonth class}
\usage{
yearmonth(year = integer(), month = integer())

as_yearmonth(x, ...)

\method{as_yearmonth}{default}(x, ...)

\method{as_yearmonth}{Date}(x, ...)

\method{as_yearmonth}{POSIXt}(x, ...)

\method{as_yearmonth}{character}(x, ...)

\method{as_yearmonth}{factor}(x, ...)

new_yearmonth(x = integer())

is_yearmonth(xx)
}
\arguments{
\item{year}{\verb{[integer]}

Vector representing the year associated with \code{month}.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{month}{\verb{[integer]}

Vector representing the month associated with \code{year}.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{x, xx}{\R objects.}

\item{...}{Only used for character input where additional arguments are passed through
to \code{as.Date()}.}
}
\value{
A \verb{<grates_yearmonth>} object.
}
\description{
\verb{<grates_yearmonth>} objects represent, unsurprisingly, years and associated months.
Internally they are stored as the number of months (starting at 0) since the
Unix Epoch (1970-01-01). Precision is only to the month level (i.e. the day
of the month is always dropped).
}
\details{
\code{yearmonth()} is a constructor for \verb{<grates_yearmonth>} objects. It takes a
vector of year and a vector of month values as inputs. Length 1 inputs will
be recycled to the length of the other input and \code{double} vectors will
be converted to integer via \code{as.integer(floor(x))}.

\code{as_yearmonth()} is a generic for coercing input in to \verb{<grates_yearmonth>}.
\itemize{
\item Character input is first parsed using \code{as.Date()}.
\item POSIXct and POSIXlt are converted with their timezone respected.
}

\code{new_yearmonth()} is a minimal constructor for \verb{<grates_yearmonth>} objects
aimed at developers. It takes, as input, the number of months (starting at 0)
since the Unix Epoch, that you wish to represent. \code{double} vectors will again
be converted to integer via \code{as.integer(floor(x))}.
}
\examples{

# date coercion
as_yearmonth(Sys.Date())

# POSIXt coercion
as_yearmonth(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"))

# character coercion
as_yearmonth("2019-05-03")

# construction
yearmonth(year = 2000, month = 3)

# direct construction
d <- seq.Date(from = as.Date("1970-01-01"), by = "month", length.out = 10)
stopifnot(
    identical(
        as_yearmonth(d),
        new_yearmonth(0:9)
    )
)

}
\references{
The algorithm to convert between dates and months relative to the UNIX Epoch
comes from the work of Davis Vaughan in the unreleased
\href{https://github.com/DavisVaughan/datea/}{datea} package
}
\seealso{
\code{new_month()} and \code{as_month()} and for grouping of consecutive months.
}
