% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grand.R
\name{grand}
\alias{grand}
\title{Apply Guidelines for Reporting About Network Data (GRAND) to an igraph object}
\usage{
grand(
  G,
  interactive = TRUE,
  name = NA,
  doi = NA,
  url = NA,
  vertex1 = NULL,
  vertex2 = NULL,
  vertex1.total = 0,
  vertex2.total = 0,
  edge.pos = NULL,
  edge.neg = NULL,
  weight = NULL,
  measure = NULL,
  mode = NULL,
  year = NULL,
  topology = character()
)
}
\arguments{
\item{G}{An \code{\link{igraph}} object, with weights/signs (if present) stored in \code{E(G)$weight}}

\item{interactive}{boolean: Should GRAND run interactively?}

\item{name}{string: Name of the network}

\item{doi}{string: DOI associated with the data}

\item{url}{string: Link to data}

\item{vertex1}{string: Entity represented by vertices}

\item{vertex2}{string: Entity represented by vertices}

\item{vertex1.total}{numeric: Number of entities in the network's boundary}

\item{vertex2.total}{numeric: Number of entities in the network's boundary}

\item{edge.pos}{string: Relationship represented by (positive) edges}

\item{edge.neg}{string: Relationship represented by negative edges}

\item{weight}{string: What the edge weights represent}

\item{measure}{string: Scale on which edge weights are measured}

\item{mode}{string: Mode of data collection}

\item{year}{numeric: Year in which data was collected}

\item{topology}{string: Vector of topological metrics to be computed in GRAND summaries}
}
\value{
An \code{\link{igraph}} object
}
\description{
The \code{grand} function stores characteristics about the graph as graph attributes that can be summarized in a narrative
using the \code{\link[=grand.text]{grand.text()}} or a table using \code{\link[=grand.table]{grand.table()}}.
}
\details{
The interactive mode (default) asks the user a series of questions based on the igraph object,
while non-interactive mode allows the user to directly supply the relevant attributes.

\strong{Data}

The first set of interactive questions ask about the data as a whole:
\itemize{
\item \emph{name} - This should usually be specified ending with the word "network" or "data"
(e.g. "Florentine Families Network" or "Airline Traffic Data").
\item \emph{doi} - DOI for a manuscript describing the data.
\item \emph{url} - Link to a copy of the data.
\item Data collection \emph{mode} - This describes how the data was collected or generated. Chose
one of the available options (Survey, Interview, Sensor, Observation, Archival, or
Simulation) or choose \code{Other} to enter something else.
\item \emph{year} - In what year were the data collected?
}

\strong{Nodes}

The second set of interactive questions ask about the nodes/vertices:
\itemize{
\item \emph{vertex1} (and in bipartite graphs, \emph{vertex2}) - What type of entity do the nodes/vertices represent?
This should be specified as a plural noun (e.g., "People").
\item \emph{vertex1.total} (and in bipartite graphs, \emph{vertex2.total}) - Networks often have an
externally-defined boundary that determines which nodes/vertices should be included,
even if some are missing from the network. These ask about the total number of nodes/vertices
inside the boundary (if one exists) and are used to compute rates of missingness.
}

\strong{Edges}

The third set of interactive questions ask about the edges:
\itemize{
\item \emph{edge.pos} (and in signed graphs, \emph{edge.neg}) - What type of relationship do the edges represent? This
should be specified as a plural noun (e.g., "Friendships").
\item \emph{weight} - What do the edge weights represent? Choose one of the available options (Frequency, Intensity,
Multiplexity, or Valence) or choose \code{Other} to enter something else.
\item \emph{measure} - How are the edge weights measured? Choose one of the available options (Continuous, Count,
Ordinal, or Categorical) or choose \code{Other} to enter something else.
}

\strong{Topology}

The final set of interactive questions ask about relevant topological characteristics. You may choose to
(1) use the defaults for this network type, (2) choose characteristics from a list, (3) compute all
available characteristics, or (4) compute no characteristics. For comparability and to ensure they are
well-defined, all characteristics are computed on an undirected and unweighted version of \code{G} using
existing \code{igraph} functions. Available topological characteristics include:
\itemize{
\item \emph{clustering coefficient} - Computed using \code{transitivity(G, type = "localaverage")}
\item \emph{degree centralization} - Computed using \code{centr_degree(G)$centralization}
\item \emph{degree distribution} - Computed using \code{fit_power_law(degree(G), implementation = "plfit")}
\item \emph{density} - Computed using \code{edge_density(G)}
\item \emph{diameter} - Computed using \code{diameter(G)}
\item \emph{efficiency} - Computed using \code{global_efficiency(G)}
\item \emph{mean degree} - Computed using \code{mean(degree(G))}
\item \emph{modularity} - Computed from a partition generated by \code{cluster_leiden(G, objective_function = "modularity")}
\item \emph{number of communities} - Computed from a partition generated by \code{cluster_leiden(G, objective_function = "modularity")}
\item \emph{number of components} - Computed using \code{count_components(G)}
\item \emph{transitivity} - Computed using \code{transitivity(G, type = "global")}
\item \emph{structural balance} - Computed using the triangle index
}
}
\examples{
data(airport)  #Load example data
airport <- grand(airport)  #Apply GRAND interactively
airport <- grand(airport, interactive = FALSE, #Apply GRAND non-interactively
                 vertex1 = "Airports",
                 vertex1.total = 382,
                 edge.pos = "Routes",
                 weight = "Passengers",
                 measure = "Count",
                 mode = "Archival",
                 year = "2019",
                 topology = c("clustering coefficient", "mean path length", "degree distribution"))
}
