% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.Dataset.R
\name{slice}
\alias{slice}
\alias{slice.gpb.Dataset}
\title{Slice a dataset}
\usage{
slice(dataset, ...)

\method{slice}{gpb.Dataset}(dataset, idxset, ...)
}
\arguments{
\item{dataset}{Object of class \code{gpb.Dataset}}

\item{...}{other parameters (currently not used)}

\item{idxset}{an integer vector of indices of rows needed}
}
\value{
constructed sub dataset
}
\description{
Get a new \code{gpb.Dataset} containing the specified rows of
             original \code{gpb.Dataset} object
}
\examples{
\donttest{
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)

dsub <- gpboost::slice(dtrain, seq_len(42L))
gpb.Dataset.construct(dsub)
labels <- gpboost::getinfo(dsub, "label")
}
}
