% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_PIOSTn.R
\name{gofPIOSTn}
\alias{gofPIOSTn}
\title{2 and 3 dimensional gof test based on the in-and-out-of-sample approach}
\usage{
gofPIOSTn(
  copula = c("normal", "t", "clayton", "gumbel", "frank", "joe", "amh", "galambos",
    "fgm", "plackett"),
  x,
  param = 0.5,
  param.est = TRUE,
  df = 4,
  df.est = TRUE,
  margins = "ranks",
  flip = 0,
  M = 1000,
  dispstr = "ex",
  m = 1,
  lower = NULL,
  upper = NULL,
  seed.active = NULL,
  processes = 1
)
}
\arguments{
\item{copula}{The copula to test for. Possible are \code{"normal"}, 
\code{"t"}, \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"joe"}, 
\code{"amh"}, \code{"galambos"}, \code{"fgm"} and \code{"plackett"}.}

\item{x}{A matrix containing the data with rows being observations and
columns being variables.}

\item{param}{The parameter to be used.}

\item{param.est}{Shall be either \code{TRUE} or \code{FALSE}. \code{TRUE}
means that \code{param} will be estimated with a maximum likelihood
estimation.}

\item{df}{Degrees of freedom, if not meant to be estimated. Only necessary
if tested for \code{"t"}-copula. For computational reasons the entry is
limited to 60 degrees of freedom.}

\item{df.est}{Indicates if \code{df} shall be estimated. Has to be either
\code{FALSE} or \code{TRUE}, where \code{TRUE} means that it will be
estimated. For computational reasons the estimate is limited to 60 degrees
of freedom.}

\item{margins}{Specifies which estimation method for the margins shall be
used. The default is \code{"ranks"}, which is the standard approach to
convert data in such a case. Alternatively the following distributions can
be specified: \code{"beta"}, \code{"cauchy"}, Chi-squared (\code{"chisq"}),
\code{"f"}, \code{"gamma"}, Log normal (\code{"lnorm"}), Normal
(\code{"norm"}), \code{"t"}, \code{"weibull"}, Exponential (\code{"exp"}).
Input can be either one method, e.g. \code{"ranks"}, which will be used for
estimation of all data sequences. Also an individual method for each margin
can be specified, e.g. \code{c("ranks", "norm", "t")} for 3 data sequences.
If one does not want to estimate the margins, set it to \code{NULL}.}

\item{flip}{The control parameter to flip the copula by 90, 180, 270 degrees
clockwise. Only applicable for bivariate copula. Default is 0 and possible 
inputs are 0, 90, 180, 270 and NULL.}

\item{M}{Number of bootstrapping loops.}

\item{dispstr}{A character string specifying the type of the symmetric
positive definite matrix characterizing the elliptical copula. Implemented
structures are "ex" for exchangeable and "un" for unstructured, see package
\code{copula}.}

\item{m}{Length of blocks.}

\item{lower}{Lower bound for the maximum likelihood estimation of the copula
parameter. The constraint is also active in the bootstrapping procedure. The
constraint is not active when a switch to inversion of Kendall's tau is
necessary. Default \code{NULL}.}

\item{upper}{Upper bound for the maximum likelihood estimation of the copula
parameter. The constraint is also active in the bootstrapping procedure. The
constraint is not active when a switch to inversion of Kendall's tau is
necessary. Default \code{NULL}.}

\item{seed.active}{Has to be either an integer or a vector of M+1 integers.
If an integer, then the seeds for the bootstrapping procedure will be
simulated. If M+1 seeds are provided, then these seeds are used in the
bootstrapping procedure. Defaults to \code{NULL}, then \code{R} generates
the seeds from the computer runtime. Controlling the seeds is useful for
reproducibility of a simulation study to compare the power of the tests or
for reproducibility of an empirical study.}

\item{processes}{The number of parallel processes which are performed to
speed up the bootstrapping. Shouldn't be higher than the number of logical
processors. Please see the details.}
}
\value{
An object of the \code{class} gofCOP with the components
\item{method}{a character which informs about the performed analysis}
\item{copula}{the copula tested for} \item{margins}{the method used to
estimate the margin distribution.} \item{param.margins}{the parameters of
the estimated margin distributions. Only applicable if the margins were not
specified as \code{"ranks"} or \code{NULL}.} \item{theta}{dependence
parameters of the copulae} \item{df}{the degrees of freedem of the copula.
Only applicable for t-copula.} \item{res.tests}{a matrix with the p-values
and test statistics of the hybrid and the individual tests}
}
\description{
\code{gofPIOSTn} tests a 2 or 3 dimensional dataset with the PIOS test for a
copula. The possible copulae are \code{"normal"}, \code{"t"}, 
\code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"joe"}, 
\code{"amh"}, \code{"galambos"}, \code{"fgm"} and \code{"plackett"}. 
The parameter estimation is performed with pseudo maximum likelihood method. 
In case the estimation fails, inversion of Kendall's tau is used. The 
approximate p-values are computed with a semiparametric bootstrap, which 
computation can be accelerated by enabling in-build parallel computation.
}
\details{
The "Tn" test is introduced in Zhang et al. (2015). It tests the
\eqn{H_0}{H0} hypothesis \deqn{H_0 : C_0 \in \mathcal{C}.}{H0 : C0 in Ccal.}
For the test blocks of length \code{m} are constructed out of the data. The
test compares then the pseudo likelihood of the data in each block with the
overall parameter and with the parameter by leaving out the data in the
block. By this procedure can be determined if the data in the block
influence the parameter estimation significantly. The test statistic is
defined as \deqn{T = \sum_{b=1}^M \sum_{k=1}^m [l\{U_k^b;\theta_n \} -
l\{U_k^b;\theta_n^{-b} \}]}{T = sum(sum(l(U_k^b;theta_n ) -
l(U_k^b;theta_n^(-b) ), k=1, ...,m ), b=1, ...,B)}

with the pseudo observations \eqn{U_{ij}}{U[ij]} for \eqn{i = 1, \dots,n}{i
= 1, ...,n}; \eqn{j = 1, \dots,d}{j = 1, ...,d} and \deqn{\theta_n = \arg
\min_{\theta} \sum_{i=1}^n l(U_i; \theta)}{theta_n = arg max_theta
sum(l(U_i; theta), i=1, ..., n)} and \deqn{\theta_n^{-b} = \arg
\min_{\theta} \sum_{b^{'} \neq b}^M \sum_{i=1}^m l(U_i^{b^{'}}; \theta),
b=1, \dots, M.}{theta_n^(-b) = arg max_theta sum(sum(l(U_i^(b^'); theta),
i=1, ..., m), b^'=1, ..., M, b^' != b), b = 1, ..., M.}

The approximate p-value is computed by the formula \deqn{\sum_{b=1}^M
\mathbf{I}(|T_b| \geq |T|) / M,}{sum(|T[b]| >= |T|, b=1, .., M) / M,}

The applied estimation method is the two-step pseudo maximum likelihood
approach, see Genest and Rivest (1995).

For small values of \code{M}, initializing the parallelisation via
\code{processes} does not make sense. The registration of the parallel
processes increases the computation time. Please consider to enable
parallelisation just for high values of \code{M}.
}
\examples{

data(IndexReturns2D)

gofPIOSTn("normal", IndexReturns2D, M = 10)

}
\references{
Zhang, S., Okhrin, O., Zhou, Q., and Song, P.. Goodness-of-fit
Test For Specification of Semiparametric Copula Dependence Models.
\emph{Journal of Econometrics, 193, 2016, pp. 215-233}
\doi{10.1016/j.jeconom.2016.02.017} \cr \cr Genest, C., K.
G. and Rivest, L.-P. (1995). A semiparametric estimation procedure of
dependence parameters in multivariate families of distributions.
\emph{Biometrika, 82:534-552}
}
