% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_genesets.R
\name{score_geneset_oddsratio}
\alias{score_geneset_oddsratio}
\title{Compute odds-ratio for each geneset}
\usage{
score_geneset_oddsratio(genesets, genelist)
}
\arguments{
\item{genesets}{tibble with genesets, must contain columns 'source', 'id', 'ngenes', 'ngenes_signif'}

\item{genelist}{tibble with genes, must contain columns 'gene', 'signif'}
}
\value{
input \code{genesets} with results in column "score_oddsratio"
}
\description{
gs_signif = number of significant genes in geneset G that intersect with user's genelist (i.e. foreground genes in G)
gs_all  = number of genes in geneset G that intersect with user's genelist (i.e. foreground+background genes in G)
k_signif = total number of \emph{significant} genes in user's genelist
k_all  = total number of genes in user's genelist

gs_signif/gs_all = ratio of foreground genes in geneset G
k_signif/k_all = ratio of overall foreground genes (i.e. expected value for a random geneset)

oddsratio = (gs_signif/gs_all) / (k_signif/k_all)
}
