% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaldAndLR.R
\name{Rao_test}
\alias{Rao_test}
\title{Perform Rao's score test for a GSMVAR model}
\usage{
Rao_test(gsmvar)
}
\arguments{
\item{gsmvar}{an object of class \code{'gsmvar'} generated by \code{fitGSMVAR} or \code{GSMVAR}, containing
the model specified by the null hypothesis (i.e., \strong{the constrained model}).}
}
\value{
A list with class "hypotest" containing the test results and arguments used to calculate the test.
}
\description{
\code{Rao_test} performs Rao's score test for a GSMVAR model
}
\details{
Tests the constraints imposed in the model given in the argument \code{GSMVAR}.
 This implementation uses the outer product of gradients approximation in the test statistic.
}
\examples{
\donttest{
## These are long running examples that use parallel computing!
## The below examples take around 30 seconds to run.

# Structural GMVAR(2, 2), d=2 model with recursive identification
# with the AR matrices  restricted to be the identical across the regimes:
W22 <- matrix(c(1, NA, 0, 1), nrow=2, byrow=FALSE)
C_mat <- rbind(diag(2*2^2), diag(2*2^2))
fit22sc <- fitGSMVAR(gdpdef, p=2, M=2, constraints=C_mat,
                     structural_pars=list(W=W22), ncalls=1, seeds=1)

# Test the null:
Rao_test(fit22sc)
}
}
\references{
\itemize{
   \item Buse A. (1982). The Likelihood Ratio, Wald, and Lagrange Multiplier Tests: An Expository Note.
     \emph{The American Statistician}, 36(3a), 153-157.
 }
}
\seealso{
\code{\link{LR_test}}, \code{\link{Wald_test}}, \code{\link{fitGSMVAR}}, \code{\link{GSMVAR}}, \code{\link{diagnostic_plot}},
 \code{\link{profile_logliks}}
}
