% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{variogramModelPlot}
\alias{variogramModelPlot}
\alias{variogramModelPlot.gmEVario}
\title{Quick plotting of empirical and theoretical variograms
Quick and dirty plotting of empirical variograms/covariances with or without their models}
\usage{
variogramModelPlot(vg, ...)

\method{variogramModelPlot}{gmEVario}(
  vg,
  model = NULL,
  col = rev(rainbow(ndirections(vg))),
  commonAxis = FALSE,
  newfig = TRUE,
  closeplot = TRUE,
  ...
)
}
\arguments{
\item{vg}{empirical variogram or covariance function}

\item{...}{further parameters to underlying plot or matplot functions}

\item{model}{optional, theoretical variogram or covariance function}

\item{col}{colors to use for the several directional variograms}

\item{commonAxis}{boolean, should all plots in a row share the same vertical axis?}

\item{newfig}{boolean, should a new figure be created? otherwise user should ensure the device space is appropriately managed}

\item{closeplot}{logical, should the plot be left open (FALSE) for further changes, or be frozen (TRUE)?
defaults to TRUE}
}
\value{
The function is primarily called for producing a plot. However, it
invisibly returns the graphical parameters active before the call
occurred. This is useful for constructing complex diagrams, by adding layers
of info. If you want to "freeze" your plot, embed your call in another
call to \code{\link{par}}, e.g. \code{par(variogramModelPlot(...))}; if you
want to leave the plot open for further changes give the extra argument \code{closeplot=FALSE}.
}
\description{
Quick plotting of empirical and theoretical variograms
Quick and dirty plotting of empirical variograms/covariances with or without their models
}
\section{Functions}{
\itemize{
\item \code{variogramModelPlot}: Quick plotting of empirical and theoretical variograms
}}

\examples{
utils::data("variogramModels")
v1 = setCgram(type=vg.Gau, sill=diag(3)+0.5, anisRanges = 5e-1*diag(c(3,0.5)))
v2 = setCgram(type=vg.Exp, sill=0.3*diag(3), anisRanges = 5e-2*diag(2))
vm = v1+v2
plot(vm, closeplot=TRUE)
library(gstat)
data("jura", package = "gstat")
X = as.matrix(jura.pred[,1:2])
Z = as.matrix(jura.pred[,c("Zn","Cd","Pb")])
vge = gsi.EVario2D(X,Z)
variogramModelPlot(vge, vm)


}
\seealso{
\code{\link[=logratioVariogram]{logratioVariogram()}}

Other variogramModelPlot: 
\code{\link{variogramModelPlot.gstatVariogram}()},
\code{\link{variogramModelPlot.logratioVariogram}()}

Other gmEVario functions: 
\code{\link{as.gmEVario.gstatVariogram}()},
\code{\link{gsi.EVario2D}()},
\code{\link{gsi.EVario3D}()},
\code{\link{ndirections}()},
\code{\link{plot.gmEVario}()}

Other gmCgram functions: 
\code{\link{[.gmCgram}()},
\code{\link{[[.gmCgram}()},
\code{\link{as.function.gmCgram}()},
\code{\link{as.gmCgram.variogramModelList}()},
\code{\link{length.gmCgram}()},
\code{\link{ndirections}()},
\code{\link{plot.gmCgram}()}
}
\concept{gmCgram functions}
\concept{gmEVario functions}
\concept{variogramModelPlot}
