% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-other-methods.R
\name{terms.gkwreg}
\alias{terms.gkwreg}
\title{Extract Terms from GKw Regression Model}
\usage{
\method{terms}{gkwreg}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"gkwreg"}.}

\item{...}{Currently not used.}
}
\value{
A terms object.
}
\description{
Extracts the terms object from a fitted Generalized Kumaraswamy regression
model.
}
\examples{
\donttest{
data(GasolineYield)
fit <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")
terms(fit)
}

}
\seealso{
\code{\link{gkwreg}}, \code{\link{formula.gkwreg}}
}
\author{
Lopes, J. E.
}
