% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-anova.R
\name{lrtest}
\alias{lrtest}
\title{Likelihood Ratio Test for Nested GKw Models}
\usage{
lrtest(object, object2)
}
\arguments{
\item{object}{A fitted model object of class \code{"gkwreg"} (the restricted model).}

\item{object2}{A fitted model object of class \code{"gkwreg"} (the full model).}
}
\value{
A list with class \code{"htest"} containing:
\describe{
\item{\code{statistic}}{The LRT test statistic}
\item{\code{parameter}}{Degrees of freedom for the test}
\item{\code{p.value}}{P-value from the chi-squared distribution}
\item{\code{method}}{Description of the test}
\item{\code{data.name}}{Names of the compared models}
}
}
\description{
Performs a likelihood ratio test to compare two nested Generalized Kumaraswamy
regression models.
}
\details{
This function performs a likelihood ratio test (LRT) to compare two nested
models. The test statistic is:
\deqn{LRT = 2(\ell_{\text{full}} - \ell_{\text{restricted}})}
which follows a chi-squared distribution with degrees of freedom equal to
the difference in the number of parameters.

The models must be nested (one is a special case of the other) and fitted to
the same data for the test to be valid.
}
\examples{
\donttest{
data(GasolineYield)

# Fit nested models
fit_restricted <- gkwreg(yield ~ temp, data = GasolineYield, family = "kw")
fit_full <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")

# Likelihood ratio test
lrtest(fit_restricted, fit_full)
}

}
\seealso{
\code{\link{anova.gkwreg}}
}
\author{
Lopes, J. E.
}
