% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-filter-spct.R
\name{scale_y_A_continuous}
\alias{scale_y_A_continuous}
\alias{scale_y_A_internal_continuous}
\alias{scale_y_A_total_continuous}
\title{Absorbance y-scale}
\usage{
scale_y_A_continuous(
  unit.exponent = 0,
  name = A_label(unit.exponent = unit.exponent, format = format, label.text = label.text,
    scaled = scaled, normalized = ifelse(is.numeric(normalized), round(normalized, 1),
    unique(normalized)), axis.symbols = axis.symbols, Tfr.type = Tfr.type),
  labels = SI_pl_format(exponent = unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  Tfr.type,
  ...
)

scale_y_A_internal_continuous(
  unit.exponent = 0,
  name = A_label(unit.exponent = unit.exponent, format = format, label.text = label.text,
    scaled = scaled, normalized = ifelse(is.numeric(normalized), round(normalized, 1),
    unique(normalized)), axis.symbols = axis.symbols, Tfr.type = "internal"),
  labels = SI_pl_format(exponent = unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)

scale_y_A_total_continuous(
  unit.exponent = 0,
  name = A_label(unit.exponent = unit.exponent, format = format, label.text = label.text,
    scaled = scaled, normalized = ifelse(is.numeric(normalized), round(normalized, 1),
    unique(normalized)), axis.symbols = axis.symbols, Tfr.type = "total"),
  labels = SI_pl_format(exponent = unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = NULL,
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{format}{character string, "R", "R.expression", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the \code{name}. Supported only by \code{format = "R.expression"}.}

\item{Tfr.type}{character, either "total" or "internal".}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for spectral absorbance.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{

ggplot(yellow_gel.spct, plot.qty = "absorbance") +
  geom_line() +
  scale_y_A_continuous(Tfr.type = getTfrType(yellow_gel.spct)) +
  scale_x_wl_continuous()

ggplot(yellow_gel.spct, plot.qty = "absorbance") +
  geom_line() +
  scale_y_A_internal_continuous() +
  scale_x_wl_continuous()

ggplot(yellow_gel.spct, plot.qty = "absorbance") +
  geom_line() +
  scale_y_A_total_continuous() +
  scale_x_wl_continuous()

ggplot(yellow_gel.spct, plot.qty = "absorbance") +
  geom_line() +
  scale_y_A_total_continuous(axis.symbols = FALSE) +
  scale_x_wl_continuous(axis.symbols = FALSE)

ggplot(yellow_gel.spct, plot.qty = "absorbance") +
  geom_line() +
  scale_y_A_internal_continuous(normalized = "none") +
  scale_x_wl_continuous()

}
