% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-rect.r
\name{coord_rect}
\alias{coord_rect}
\alias{coord_square}
\title{Cartesian coordinates and plotting window with fixed aspect ratios}
\usage{
coord_rect(
  ratio = 1,
  window_ratio = ratio,
  xlim = NULL,
  ylim = NULL,
  expand = TRUE,
  clip = "on"
)
}
\arguments{
\item{ratio}{aspect ratio, expressed as \code{y / x}}

\item{window_ratio}{aspect ratio of plotting window}

\item{xlim, ylim}{Limits for the x and y axes.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}
}
\value{
A \code{Coord} \link[=gggda-ggproto]{ggproto} object.
}
\description{
Geometric data analysis often requires that coordinates lie on
the same scale. The coordinate system \code{CoordRect}, alias \code{CoordSquare},
provides control of both coordinate and window aspect ratios.
}
\examples{
# ensures that the resolutions of the axes and the dimensions of the plotting
# window respect the specified aspect ratios
p <- ggplot(mtcars, aes(mpg, hp/10)) + geom_point()
p + coord_rect(ratio = 1)
p + coord_rect(ratio = 1, window_ratio = 2)
p + coord_rect(ratio = 1, window_ratio = 1/2)
p + coord_rect(ratio = 5)
p + coord_rect(ratio = 1/5)
p + coord_rect(xlim = c(15, 30))
p + coord_rect(ylim = c(15, 30))

# square (even excluding some geometric constructions)
p + coord_square(xlim = c(0, 30), ylim = c(20, 40))
}
