% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bloom.R
\name{with_bloom}
\alias{with_bloom}
\title{Apply bloom to your layer}
\usage{
with_bloom(
  x,
  threshold_lower = 80,
  threshold_upper = 100,
  sigma = 5,
  strength = 1,
  keep_alpha = TRUE,
  ...
)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{threshold_lower, threshold_upper}{The lowest channel value to consider
emitting light and the highest channel value that should be considered
maximum light strength, given in percent}

\item{sigma}{The standard deviation of the gaussian kernel used for the
bloom. Will affect the size of the halo around light objects}

\item{strength}{A value between 0 and 1 to use for changing the strength of
the effect.}

\item{keep_alpha}{Should the alpha channel of the layer be kept, effectively
limiting the bloom effect to the filtered layer. Setting this to false will
allow the bloom to spill out to the background, but since it is not being
blended correctly with the background the effect looks off.}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
Bloom is the effect of strong light sources spilling over into neighbouring
dark areas. It is used a lot in video games and movies to give the effect of
strong light, even though the monitor is not itself capable of showing light
at that strength.
}
\examples{
library(ggplot2)
points <- data.frame(
  x = runif(1000),
  y = runif(1000),
  col = runif(1000)
)
ggplot(points, aes(x, y, colour = col)) +
  with_bloom(
    geom_point(size = 10),
  ) +
  scale_colour_continuous(type = 'viridis')

}
