% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_aux.R
\name{gf_guides}
\alias{gf_guides}
\title{Guides for ggformula}
\usage{
gf_guides(object, ...)
}
\arguments{
\item{object}{a gg object}

\item{...}{arguments passed to \code{\link[ggplot2:guides]{ggplot2::guides()}}.}
}
\value{
a modified gg object
}
\description{
Guides for each scale can be set scale-by-scale with the \code{guide} argument,
or en masse with \code{gf_guides()}.
}
\examples{

dat <-
  data.frame(
    x = 1:5, y = 1:5,
    p = 1:5, q = factor(1:5), r = factor(1:5)
 )

p <-
  dat |>
  gf_point( y ~ x, colour = ~ p, size = ~ q, shape = ~r)

# without guide specification
p

# Show colorbar guide for colour.
# All these examples below have a same effect.

p |> gf_guides(colour = "colorbar", size = "legend", shape = "legend")
p |> gf_guides(colour = guide_colorbar(), size = guide_legend(),
           shape = guide_legend())
p +
  scale_colour_continuous(guide = "colorbar") +
  scale_size_discrete(guide = "legend") +
  scale_shape(guide = "legend")

# Remove some guides
p |> gf_guides(colour = "none")
p |> gf_guides(colour = "colorbar",size = "none")

# Guides are integrated where possible

p |>
  gf_guides(
    colour = guide_legend("title"),
    size = guide_legend("title"),
    shape = guide_legend("title")
  )
g <- guide_legend("title")
p |> gf_guides(colour = g, size = g, shape = g)

p |> gf_theme(legend.position = "bottom")

# position of guides

# Set order for multiple guides
mpg |>
  gf_point(cty ~ displ, size = ~hwy, shape = ~ drv) |>
  gf_guides(
    colour = guide_colourbar(order = 1),
    shape = guide_legend(order = 2),
    size = guide_legend(order = 3)
  )
}
\seealso{
\code{\link[ggplot2:guides]{ggplot2::guides()}}
}
