% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-align_plots.R
\name{layout_design}
\alias{layout_design}
\title{Define the grid to compose plots in}
\usage{
layout_design(
  ncol = waiver(),
  nrow = waiver(),
  byrow = waiver(),
  widths = waiver(),
  heights = waiver(),
  design = waiver(),
  guides = NA
)
}
\arguments{
\item{ncol, nrow}{The dimensions of the grid to create - if both are \code{NULL} it
will use the same logic as \code{\link[ggplot2:facet_wrap]{facet_wrap()}} to set the
dimensions}

\item{byrow}{If \code{FALSE} the plots will be filled in in column-major order.}

\item{widths, heights}{The relative widths and heights of each column and row
in the grid. Will get repeated to match the dimensions of the grid. The
special value of \code{NA} will behave as \verb{1null} unit unless a fixed aspect plot
is inserted in which case it will allow the dimension to expand or contract
to match the aspect ratio of the content.}

\item{design}{Specification of the location of areas in the layout. Can
either be specified as a text string or by concatenating calls to
\code{\link[=area]{area()}} together.}

\item{guides}{A string with one or more of \code{"t"}, \code{"l"}, \code{"b"}, \code{"r"}, and \code{"i"}
indicating which side of guide legends should be collected. Defaults to
\code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If
there is no parent layout, or if \code{NULL} is provided, no guides will be
collected.}
}
\value{
A \code{layout_design} object.
}
\description{
To control how different plots are laid out, you need to add a layout design
specification. If you are nesting grids, the layout is scoped to the current
nesting level.
}
\examples{
p1 <- ggplot(mtcars) +
    geom_point(aes(mpg, disp))
p2 <- ggplot(mtcars) +
    geom_boxplot(aes(gear, disp, group = gear))
p3 <- ggplot(mtcars) +
    geom_bar(aes(gear)) +
    facet_wrap(~cyl)
align_plots(p1, p2, p3) +
    layout_design(nrow = 1L)
align_plots(p1, p2, p3) +
    layout_design(ncol = 1L)
}
