% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geostan_fit-methods.R
\name{print.geostan_fit}
\alias{print.geostan_fit}
\alias{plot.geostan_fit}
\title{print or plot a fitted geostan model}
\usage{
\method{print}{geostan_fit}(x, probs = c(0.025, 0.2, 0.5, 0.8, 0.975), digits = 3, pars = NULL, ...)

\method{plot}{geostan_fit}(x, pars, plotfun = "hist", fill = "steelblue4", ...)
}
\arguments{
\item{x}{A fitted model object of class \code{geostan_fit}.}

\item{probs}{Argument passed to \code{quantile}; which quantiles to calculate and print.}

\item{digits}{number of digits to print}

\item{pars}{parameters to include; a character string (or vector) of parameter names.}

\item{...}{additional arguments to \code{rstan::plot} or \code{rstan::print.stanfit}.}

\item{plotfun}{Argument passed to \code{rstan::plot}. Options include histograms ("hist"), MCMC traceplots ("trace"), and density plots ("dens"). Diagnostic plots are also available such as Rhat statistics ("rhat"), effective sample size ("ess"), and MCMC autocorrelation ("ac").}

\item{fill}{fill color for histograms and density plots.}
}
\value{
The print methods writes text to the console to summarize model results. The plot method resturns a \code{ggplot} (from \code{rstan::plot} for stanfit objects).
}
\description{
Print a summary of model results to the R console, or plot posterior distributions of model parameters.
}
\examples{
data(georgia)
georgia$income <- georgia$income/1e3

fit <- stan_glm(deaths.male ~ offset(log(pop.at.risk.male)) + log(income),
                centerx = TRUE,
                data = georgia,
                family = poisson(),
                chains = 2, iter = 600) # for speed only


# print and plot results
print(fit)
plot(fit)
}
