% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_variables.R
\name{write_variables}
\alias{write_variables}
\title{Write Variables YAML for 'Quarto' Projects}
\usage{
write_variables(path = here::here(), .initialize_proj = FALSE)
}
\arguments{
\item{path}{Character string. Path to the project directory.}

\item{.initialize_proj}{Logical. TRUE only if starting a 
\code{froggeR::quarto_project()}.}
}
\value{
Invisibly returns `NULL` after creating or updating the `_variables.yml` file.
}
\description{
This function creates or updates the `_variables.yml` file in a Quarto project
directory using froggeR settings, if they exist in the config path.
}
\details{
The function will attempt to use the current froggeR settings from the config path. If
no global configurations exist, a template `_variables.yml` will be created.
}
\examples{

# Write the _variables.yml file
if (interactive()) {
  temp_dir <- tempdir()
  write_variables(temp_dir)
}

}
