% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_profile.R
\name{species_profile}
\alias{species_profile}
\title{Generate the co-occurrence profile for a species}
\usage{
species_profile(species, inventory_list, native = FALSE)
}
\arguments{
\item{species}{The scientific name of the target plant species}

\item{inventory_list}{A list of site inventories having the format of
\code{\link[=assessment_list_inventory]{assessment_list_inventory()}}}

\item{native}{Logical indicating whether only native co-occurrences should be
considered.}
}
\value{
A data frame with 14 columns:
\itemize{
\item target_species (character)
\item target_species_c (numeric)
\item cospecies_n (numeric)
\item cospecies_native_n (numeric)
\item cospecies_mean_c (numeric)
\item cospecies_native_mean_c  (numeric)
\item cospecies_std_dev_c  (numeric)
\item cospecies_native_std_dev_c  (numeric)
\item percent_native  (numeric)
\item percent_nonnative (numeric)
\item percent_native_low_c (numeric)
\item percent_native_med_c  (numeric)
\item percent_native_high_c  (numeric)
\item discrepancy_c (numeric)
}
}
\description{
\code{species_profile()} accepts a species and list of inventories like those
generated by
\code{\link[=assessment_list_inventory]{assessment_list_inventory()}} and
returns the co-occurrence profile of that species. Repeated co-occurrences
across multiple assessments are included in summary calculations but self
co-occurrences are not.
}
\examples{
# species_profile() is best used in combination with
# download_assessment_list() and assessment_list_inventory().

\donttest{
ontario <- download_assessment_list(database = 2)
ontario_invs <- assessment_list_inventory(ontario)
species_profile("Aster lateriflorus", ontario_invs)
}

}
