% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_nativity.R
\name{species_nativity}
\alias{species_nativity}
\title{Nativity of a species in a specified database}
\usage{
species_nativity(species, database_id = NULL, database_inventory = NULL)
}
\arguments{
\item{species}{The scientific name of the plant species of interest}

\item{database_id}{ID number of an existing database on
\href{https://universalfqa.org/}{universalfqa.org}. Use
\code{\link[=index_fqa_databases]{index_fqa_databases()}} to see a list of
all such databases.}

\item{database_inventory}{An inventory of species having the same form as one
  created using \code{\link[=database_inventory]{database_inventory()}}, that
  is, a data frame with 9 columns:
  \itemize{
   \item scientific_name (character)
   \item family (character)
   \item acronym (character)
   \item nativity (character)
   \item c (numeric)
   \item w (numeric)
   \item physiognomy (character)
   \item duration (character)
   \item common_name (character)
}}
}
\value{
The nativity of the given species within the given database, either
  native or non-native.
}
\description{
\code{species_nativity()} accepts a species and a database inventory and returns the
nativity of that species. Either a numeric database ID from
\href{https://universalfqa.org/}{universalfqa.org} or a homemade inventory
with the same format may be specified.
}
\examples{
species_nativity("Anemone canadensis", database_id = 149)

}
