% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta.R
\name{thetam}
\alias{thetam}
\title{Theta method 'model'}
\usage{
thetam(y)
}
\arguments{
\item{y}{A numeric vector or time series.}
}
\value{
An object of class \code{thetam}
}
\description{
Create a model object as an interim step to a theta method forecast.
}
\details{
This fits an exponential smoothing state space model with
\code{model = 'ANN'} to \code{y}, having first performed classic multiplicative
seasonal adjustment.  A drift value is also calculated by
\code{lsfit(0:(length(y) - 1), y)$coef[2] / 2}.  In combination with \code{forecast.thetam()},
this provides identical results to \code{forecast::thetaf(...)}.  The  purpose of splitting
it into a `model` and `forecast` functions is to make the approach consistent with other
modeling / forecasting approaches used in \code{hybridModel()}.
}
\examples{
mod1 <- thetam(Nile)
plot(mod1)
}
\seealso{
\code{\link{forecast.thetam}}
}
\author{
Peter Ellis
}
