% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotOptions.R
\name{plotOptions}
\alias{plotOptions}
\title{Plots the differences in performance metrics from two system options}
\usage{
plotOptions(
  performanceOpt1,
  performanceOpt2,
  sim,
  metric = NULL,
  attX = NULL,
  attY = NULL,
  topReps = NULL,
  opt1Label = "Option 1",
  opt2Label = "Option 2",
  titleText = paste0(opt2Label, " - ", opt1Label),
  perfThresh = NULL,
  perfThreshLabel = "Threshold",
  attSlices = NULL,
  climData = NULL,
  colMap = NULL,
  colLim = NULL
)
}
\arguments{
\item{performanceOpt1}{a named list; contains the system model performance calculated using \code{runSystemModel} for system model option 1. 
If the list contains more than one performance metric, the argument \code{metric} can be used to specify the metric to be used.}

\item{performanceOpt2}{a named list; contains the system model performance calculated using \code{runSystemModel} for system model option 2. 
If the list contains more than one performance metric, the argument \code{metric} can be used to specify the metric to be used.}

\item{sim}{a list; summary of the simulation containing the scenarios generated using the function \code{generateScenarios} that is used to run the system model using \code{runSystemModel}.
The summary of the simulation may be obtained by using the function \code{getSimSummary} on the full simulation. The summary object is much smaller in size for ease of storage and use with the performance
plotting functions like \code{plotPerformanceSpace}.}

\item{metric}{a string; the name of the performance metric to be plotted. The argument can be used to select the metric from 
\code{performanceOpt1} and \code{performanceOpt2} lists for plotting. If \code{NULL} (the default), the first metric in the lists will be used.}

\item{attX}{a string; the tag of the perturbed attribute to plot on the xaxis. The attribute must be one of the perturbed attributes of \code{sim}.
Type \code{sim$expSpace$attPerturb} to view all perturbed attributes of \code{sim}. If \code{NULL} (default), the first perturbed attribute of \code{sim} will be used.}

\item{attY}{a string; the tag of the perturbed attribute to plot on the yaxis. The attribute must be another perturbed attribute of \code{sim}.
If \code{NULL}, the second perturbed attribute of \code{sim} will be used.}

\item{topReps}{an integer (default is \code{NULL}); the number of "top" replicates in terms of simulation fitness to be used. If \code{topReps} is specified, \code{topReps}
number of replicates will be identified for each target and the average performance across these replicates will be plotted. If \code{NULL}, the average performance across all the replicates will be plotted.}

\item{opt1Label}{a string; the text to label \code{performanceOpt1}.}

\item{opt2Label}{a string; the text to label \code{performanceOpt2}.}

\item{titleText}{a string; text for the title of the plot. The default is \code{paste0(opt2Label, " - ", opt1Label)}.}

\item{perfThresh}{a number; the minimum or maximum threshold value of the performance metric. A line will be drawn to mark this threshold value in the performance space.}

\item{perfThreshLabel}{a string; the text to label \code{perfThresh}.}

\item{attSlices}{a list; used to subset perturbed attributes in \code{sim} for the plot. This argument would typically be used in cases where there are more than two perturbed attributes.
The elements of the list correspond to the perturbed attributes to be subsetted and must be named using the attribute tag. Each element may contain a single value or a two-element vector specifying the minimum-maximum values.
If the element is a single value, the exposure space is sliced on this single value of the attribute. If minimum-maximum values are specified, the exposure space will be sliced to subset this range.
If \code{attSlices} includes \code{attX} or \code{attY}, these attributes will be sliced and the resulting plot will be a "zoomed-in" space.}

\item{climData}{data.frame; the values of attX and attY from other sources like climate models. This data will be plotted as points in the performance space.
The data frame may contain columns with values of the performance metric to be plotted and the "Name" of the dataset.
If the performance metric is available in the data.frame, the points will be coloured based on the performance \code{colMap} scale.
If the \code{Name} of the data is available in the data.frame, the points will be identified using the \code{Name}.
Please refer data provided with the package that may be loaded using \code{data("egClimData")} for an example of the expected format of \code{climData}.}

\item{colMap}{a vector of colours; to specify the colourmap to be used. If \code{NULL}, the default foreSIGHT colourmap is used.}

\item{colLim}{a vector of 2 values; the minimum and maximum limits of the colour scale.}
}
\value{
The plot of the differences in the performance metrics (option 2 - option 1) in a ggplot object.
}
\description{
\code{plotOptions} uses the system model performances calculated using the function \code{runSystemModel} for two alternate system model options,
and the summary of the simulation generated using the functions \code{generateScenarios} & \code{getSimSummary} as input. The function plots the differences in 
the performance metrics between the two options, and the changes in performance thresholds in the space. 
The user may specify the attributes to be used as the axes of the plot. The function contains arguments to control the finer details of the plot.
}
\examples{
# load example datasets
data("egSimSummary")
data("egSimPerformance")       # performance of option1
data("egSimPerformance_systemB")  # performance of option2
data("egClimData")
plotOptions(egSimPerformance[1], egSimPerformance_systemB [1], egSimSummary, 
attX = "P_ann_seasRatio", attY = "P_ann_tot_m", topReps = 7, perfThreshLabel = "Threshold (28L)",
perfThresh = 28,  opt1Label = "System A", opt2Label = "System B", climData = egClimData)
}
\seealso{
\code{runSystemModel}, \code{plotPerformanceSpace}, \code{generateScenarios}, \code{getSimSummary}
}
