% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiBin.R
\name{EstMLEMultiBin}
\alias{EstMLEMultiBin}
\title{Estimating the probability of success and theta for Multiplicative Binomial
Distribution}
\usage{
EstMLEMultiBin(x,freq,p,theta,...)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{p}{single value for probability of success.}

\item{theta}{single value for theta parameter.}

\item{...}{mle2 function inputs except data and estimating parameter.}
}
\value{
\code{EstMLEMultiBin} here is used as a wrapper for the \code{mle2} function of
\pkg{bbmle} package therefore output is of class of mle2.
}
\description{
The function will estimate the probability of success and theta parameter using the
maximum log likelihood method for the Multiplicative Binomial distribution when the binomial random
variables and corresponding frequencies are given.
}
\details{
\deqn{freq \ge 0}
\deqn{x = 0,1,2,..}
\deqn{0 < p < 1}
\deqn{0 < theta }
}
\examples{
No.D.D <- 0:7         #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)    #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters <- EstMLEMultiBin(x=No.D.D,freq=Obs.fre.1,p=0.5,theta=15)

bbmle::coef(parameters)           #extracting the parameters

}
\references{
\insertRef{johnson2005univariate}{fitODBOD}
\insertRef{kupper1978use}{fitODBOD}
\insertRef{paul1985three}{fitODBOD}
}
\seealso{
\code{\link[bbmle]{mle2}}
}
