% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_data.R
\name{get_trained_models}
\alias{get_trained_models}
\title{Get Final Trained Models}
\usage{
get_trained_models(run_info)
}
\arguments{
\item{run_info}{run info using the \code{\link[=set_run_info]{set_run_info()}} function}
}
\value{
table of final trained models
}
\description{
Get Final Trained Models
}
\examples{
\donttest{
data_tbl <- timetk::m4_monthly \%>\%
  dplyr::rename(Date = date) \%>\%
  dplyr::mutate(id = as.character(id)) \%>\%
  dplyr::filter(
    id == "M2",
    Date >= "2012-01-01",
    Date <= "2015-06-01"
  )

run_info <- set_run_info()

prep_data(run_info,
  input_data = data_tbl,
  combo_variables = c("id"),
  target_variable = "value",
  date_type = "month",
  forecast_horizon = 3,
  recipes_to_run = "R1"
)

prep_models(run_info,
  models_to_run = c("arima", "ets"),
  num_hyperparameters = 1
)

train_models(run_info,
  run_global_models = FALSE,
  run_local_models = TRUE
)

final_models(run_info,
  average_models = FALSE
)

models_tbl <- get_trained_models(run_info)
}
}
