% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_shape_dist.R
\name{calc_shape_dist}
\alias{calc_shape_dist}
\title{Elastic Shape Distance}
\usage{
calc_shape_dist(
  beta1,
  beta2,
  mode = "O",
  alignment = TRUE,
  rotation = TRUE,
  scale = TRUE,
  optim_method = "DP",
  include.length = FALSE,
  lambda = 0
)
}
\arguments{
\item{beta1}{A numeric matrix of shape \eqn{L \times M} specifying an
\eqn{L}-dimensional curve evaluated on \eqn{M} sample points.}

\item{beta2}{A numeric matrix of shape \eqn{L \times M} specifying an
\eqn{L}-dimensional curve evaluated on \eqn{M} sample points. This curve
will be aligned to \code{beta1}.}

\item{mode}{A character string specifying whether the input curves should be
considered open (\code{mode == "O"}) or closed (\code{mode == "C"}). Defaults to
\code{"O"}.}

\item{alignment}{A boolean value specifying whether the curves should be
aligned before computing the distance matrix. Defaults to \code{TRUE}.}

\item{rotation}{A boolean specifying whether the distance should be made
invariant by rotation. Defaults to \code{TRUE}.}

\item{scale}{A boolean specifying whether the distance should be made
invariant by scaling. This is effectively achieved by making SRVFs having
unit length and switching to an appropriate metric on the sphere between
normalized SRVFs. Defaults to \code{TRUE}.}

\item{optim_method}{A string specifying the algorithm used for optimization.
Choices are \code{"DP"} and \code{"DPo"} Defaults to \code{"DP"}.}

\item{include.length}{A boolean specifying whether to include information
about the actual length of the SRVFs in the metric when using normalized
SRVFs to achieve scale invariance. This only applies if \code{scale == TRUE}.
Defaults to \code{FALSE}.}

\item{lambda}{A numeric value specifying the weight of a penalty term that
constraints the warping function to be not too far from the identity.
Defaults to \code{0.0}.}
}
\value{
A list with the following components:
\itemize{
\item \code{d}: the amplitude (geodesic) distance;
\item \code{dx}: the phase distance;
\item \code{q1}: the SRVF of \code{beta1};
\item \code{q2n}: the SRVF of \code{beta2} after alignment and possible optimal rotation
and scaling;
\item \code{beta1}: the input curve \code{beta1};
\item \code{beta2n}: the input curve \code{beta2} after alignment and possible optimal
rotation and scaling.
\item \code{R}: the optimal rotation matrix that has been applied to the second curve;
\item \code{gam}: the optimal warping function that has been applied to the second
curve;
\item \code{betascale}: the optimal scaling factor that has been applied to the second
curve.
}
}
\description{
Calculates the elastic shape distance between two curves \code{beta1} and \code{beta2}.
}
\details{
Distances are computed between the SRVFs of the original curves. Hence, they
are intrinsically invariant to position. The user can then choose to make
distances invariant to rotation and scaling by setting \code{rotation} and \code{scale}
accordingly. Distances can also be made invariant to reparameterization by
setting \code{alignment = TRUE}, in which case curves are aligned using an
appropriate action of the diffeomorphism group on the space of SRVFs.
}
\examples{
out <- calc_shape_dist(beta[, , 1, 1], beta[, , 1, 4])
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape
analysis of elastic curves in euclidean spaces. Pattern Analysis and
Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.

Kurtek, S., Srivastava, A., Klassen, E., and Ding, Z. (2012),
“Statistical Modeling of Curves Using Shapes and Related Features,” Journal
of the American Statistical Association, 107, 1152–1165.

Srivastava, A., Klassen, E. P. (2016). Functional and shape
data analysis, 1. New York: Springer.
}
\keyword{distances}
