% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleRast.r
\name{sampleRast,GRaster-method}
\alias{sampleRast,GRaster-method}
\alias{sampleRast}
\title{Randomly sample cells from a GRaster}
\usage{
\S4method{sampleRast}{GRaster}(
  x,
  size,
  prop = FALSE,
  maskvalues = NA,
  updatevalue = NULL,
  test = FALSE,
  seed = NULL
)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{size}{Numeric: Number of cells or proportion of cells to select.}

\item{prop}{Logical: If \code{TRUE}, the value of \code{size} will be interpreted as a proportion of cells. The default is \code{FALSE} (\code{size} is interpreted as the number of cells to select).}

\item{maskvalues}{Numeric vector, including \code{NA}, or \code{NULL} (default): Values in the raster to select from. All others will be ignored. If this is \code{NULL}, then only non-\code{NA} cells will be selected for retention.}

\item{updatevalue}{Numeric or \code{NULL} (default): Value to assign to masked cells. If \code{NULL}, then the values in the input raster are retained.}

\item{test}{Logical: If \code{TRUE}, and \code{size} is greater than the number of non-\code{NA} cells in \code{x}, then fail. Testing this can take a long time for large rasters. The default is \code{FALSE}.}

\item{seed}{\code{NULL} (default) or numeric: If \code{NULL}, then a random seed will be generated for the random number generator. Otherwise a seed can be provided.}
}
\value{
A \code{GRaster}.
}
\description{
\code{sampleRast()} randomly samples cells from non-\code{NA} cells of a raster. The output will be a raster with selected non-\code{NA} cells, and all other cells set to \code{NA}. To generate random points, see \code{\link[=spatSample]{spatSample()}}.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Example data
madElev <- fastData("madElev") # raster

# Convert to GRasters and GVectors
elev <- fast(madElev)

### spatSample()

# Random points as data.frame or data.table:
randVals <- spatSample(elev, size = 20, values = TRUE)
randVals

# Random points as a points GVector:
randPoints <- spatSample(elev, size = 20, as.points = TRUE)
randPoints
plot(elev)
plot(randPoints, add = TRUE)

# Random points in a select area:
madCoast <- fastData("madCoast4") # vector
coast <- fast(madCoast)
ant <- coast[coast$NAME_4 == "Antanambe"] # subset

restrictedPoints <- spatSample(elev, size = 20, as.points = TRUE,
   strata = ant)

plot(elev)
plot(ant, add = TRUE)
plot(restrictedPoints, add = TRUE) # note 20 points for entire geometry

# Random points, one set per subgeometry:
stratifiedPoints <- spatSample(elev, size = 20, as.points = TRUE,
   strata = ant, byStratum = TRUE)

plot(elev)
plot(ant, add = TRUE)
plot(stratifiedPoints, pch = 21, bg = "red", add = TRUE) # note 20 points per subgeometry

# Random categories:
madCover <- fastData("madCover") # raster
cover <- fast(madCover)

randCover <- spatSample(cover, size = 20, values = TRUE,
     cat = TRUE, xy = TRUE)
randCover

### sampleRast()

# Random cells in non-NA cells:
rand <- sampleRast(elev, 10000)
plot(rand)
nonnacell(rand)

# Use custom values for the mask:
randCustomMask <- sampleRast(elev, 10000, maskvalues = 1:20)
plot(randCustomMask)

# Force selected values to a custom value:
randCustomUpdate <- sampleRast(elev, 10000, updatevalue = 7)
plot(randCustomUpdate)

# Custom values for mask and set selected cells to custom value:
randAll <- sampleRast(elev, 10000, maskvalues = 1:20, updatevalue = 7)
plot(randAll)

}
}
\seealso{
\code{\link[=spatSample]{spatSample()}}; \code{\link[terra:sample]{terra::spatSample()}}, tool \code{r.random} in \strong{GRASS}
}
