% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_expectation}
\alias{plot_expectation}
\alias{plot_dense_matrix}
\alias{plot_sparse_matrix}
\title{Plot (expected) adjacency matrices}
\usage{
plot_expectation(model)

plot_dense_matrix(A, ...)

plot_sparse_matrix(A)
}
\arguments{
\item{model}{A \code{\link[=directed_factor_model]{directed_factor_model()}} or an \code{\link[=undirected_factor_model]{undirected_factor_model()}}
object.}

\item{A}{A \code{\link[=matrix]{matrix()}}, \code{\link[Matrix:Matrix]{Matrix::Matrix()}} or \code{\link[Matrix:sparseMatrix]{Matrix::sparseMatrix()}} object.}

\item{...}{Unused.}
}
\value{
A \code{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2()}} plot.
}
\description{
Plot (expected) adjacency matrices
}
\examples{

set.seed(27)

model <- dcsbm(n = 10, k = 2, expected_density = 0.2)

plot_expectation(model)

A <- sample_sparse(model)

plot_sparse_matrix(A)

}
