# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title ColumnSummary
#' @description ColumnSummary Class
#' @format An \code{R6Class} generator object
#' @field name  character [optional]
#'
#' @field directory  character [optional]
#'
#' @field category  character [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
ColumnSummary <- R6::R6Class(
  'ColumnSummary',
  public = list(
    `name` = NULL,
    `directory` = NULL,
    `category` = NULL,
    initialize = function(`name`=NULL, `directory`=NULL, `category`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`name`)) {
        stopifnot(is.character(`name`), length(`name`) == 1)
        self$`name` <- `name`
      }
      if (!is.null(`directory`)) {
        stopifnot(is.character(`directory`), length(`directory`) == 1)
        self$`directory` <- `directory`
      }
      if (!is.null(`category`)) {
        stopifnot(is.character(`category`), length(`category`) == 1)
        self$`category` <- `category`
      }
    },
    toJSON = function() {
      ColumnSummaryObject <- list()
      if (!is.null(self$`name`)) {
        ColumnSummaryObject[['name']] <-
          self$`name`
      }
      if (!is.null(self$`directory`)) {
        ColumnSummaryObject[['directory']] <-
          self$`directory`
      }
      if (!is.null(self$`category`)) {
        ColumnSummaryObject[['category']] <-
          self$`category`
      }

      ColumnSummaryObject
    },
    fromJSON = function(ColumnSummaryJson) {
      ColumnSummaryObject <- jsonlite::fromJSON(ColumnSummaryJson)
      if (!is.null(ColumnSummaryObject$`name`)) {
        self$`name` <- ColumnSummaryObject$`name`
      }
      if (!is.null(ColumnSummaryObject$`directory`)) {
        self$`directory` <- ColumnSummaryObject$`directory`
      }
      if (!is.null(ColumnSummaryObject$`category`)) {
        self$`category` <- ColumnSummaryObject$`category`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`name`)) {
        sprintf(
        '"name":
          "%s"
                ',
        self$`name`
        )},
        if (!is.null(self$`directory`)) {
        sprintf(
        '"directory":
          "%s"
                ',
        self$`directory`
        )},
        if (!is.null(self$`category`)) {
        sprintf(
        '"category":
          "%s"
                ',
        self$`category`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(ColumnSummaryJson) {
      ColumnSummaryObject <- jsonlite::fromJSON(ColumnSummaryJson)
      self$`name` <- ColumnSummaryObject$`name`
      self$`directory` <- ColumnSummaryObject$`directory`
      self$`category` <- ColumnSummaryObject$`category`
      self
    }
  )
)
