% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-confounds.R
\name{summarize_confounds}
\alias{summarize_confounds}
\title{Extract confounding variables calculated separately for each pupil data file}
\usage{
summarize_confounds(eyeris)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} derived from \code{\link[=load_asc]{load_asc()}}}
}
\value{
An \code{eyeris} object with a new nested list of data frames:
\verb{$confounds}
The confounds are organized hierarchically by block and preprocessing step.
Each step contains metrics such as:
\itemize{
\item Blink rate and duration statistics
\item Gaze position (x,y) mean and standard deviation
\item Pupil size mean, standard deviation, and range
\item Missing data percentage
}
}
\description{
Calculates various confounding variables for pupil data, including blink
statistics, gaze position metrics, and pupil size characteristics. These
confounds are calculated separately for each preprocessing step, recording
block, and epoched timeseries in the eyeris object.
}
\examples{
# load demo dataset
demo_data <- eyelink_asc_demo_dataset()

# calculate confounds for all blocks and preprocessing steps
confounds <- demo_data |>
  eyeris::glassbox() |>
  eyeris::epoch(
    events = "PROBE_{type}_{trial}",
    limits = c(-1, 1), # grab 1 second prior to and 1 second post event
    label = "prePostProbe" # custom epoch label name
  ) |>
  eyeris::summarize_confounds()

# access confounds for entire timeseries for a specific block and step
confounds$confounds$unepoched_timeseries

# access confounds for a specific epoched timeseries
# for a specific block and step
confounds$confounds$epoched_timeseries
confounds$confounds$epoched_epoch_wide

}
