% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recodeye.R
\name{recodeye}
\alias{recodeye}
\title{Recode eyes}
\usage{
recodeye(x, to = NULL, eyestrings = NULL, dropunknown = TRUE)
}
\arguments{
\item{x}{vector of strings}

\item{to}{named vector to which eye codes. If unnamed, this order: c(r, l, b)}

\item{eyestrings}{named list of substrings which should be converted to
right and left eyes - if passed unnamed, this order: list(r, l, b)}

\item{dropunknown}{introduces NA for values that are not part of eyestrings}
}
\value{
Character vector
}
\description{
recoding eyes to "r" and "l"
}
\section{string detection}{

recodeye will automatically detect the following strings:
right = c("r", "re", "od", "right"),
left = c("l", "le", "os", "left"),
both = c("b","both","ou")

You can change this with \link{set_eye_strings}
}

\section{to and eyecode arguments}{

If passed, should ideally be of same length, and have the respective eyes
at the same index (or with the same name!). If the lengths are not equal,
e.g., if only "to" is passed with n elements, the shorter argument will be
will be cut down to the first n elements of the longer argument.

Note that all unique strings which are part of the column should be contained
in the "eyecode" argument.
}

\section{numeric coding}{

Currently numeric coding only accepts binary
coding (right and left eye). In order to use numeric coding for "both eyes"
as well, a workaround using the eyestrings argument is suggested.
}

\examples{
x <- c("r", "re", "od", "right", "l", "le", "os", "left", "both", "ou")
recodeye(x)

## chose the resulting codes
recodeye(x, to = c("od", "os", "ou"))

x <- 1:2
recodeye(x)

## If you code your eyes with different strings,
## e.g., because you are using a different language,
## you can change this either with the eyestrings argument,
french <- c("OD", "droit", "gauche", "OG")
recodeye(french, eyestrings = list(r = c("droit", "od"), l = c("gauche", "og")))

## or change it more globally with `set_eye_strings`
set_eye_strings(right = c("droit", "od"), left = c("gauche", "og"))
recodeye(french)

## restore defaults with
set_eye_strings()
}
\seealso{
Other string matching functions: 
\code{\link{getElem}},
\code{\link{sort_substr}()},
\code{\link{str_search}}
}
\concept{string matching functions}
