% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_ctd.R
\name{extr_tetramer}
\alias{extr_tetramer}
\title{Extract Tetramer Data from the CTD API}
\usage{
extr_tetramer(
  chem,
  disease = "",
  gene = "",
  go = "",
  input_term_search_type = "directAssociations",
  qt_match_type = "equals",
  verify_ssl = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{chem}{A string indicating the chemical identifiers such as CAS number or
IUPAC name of the chemical.}

\item{disease}{A string indicating a disease term. Default is an empty string.}

\item{gene}{A string indicating a gene symbol. Default is an empty string.}

\item{go}{A string indicating a Gene Ontology term. Default is an empty string.}

\item{input_term_search_type}{A string specifying the search method to use.
Options are "hierarchicalAssociations" or "directAssociations". Default is
"directAssociations".}

\item{qt_match_type}{A string specifying the query type match method. Options
are "equals" or "contains". Default is "equals".}

\item{verify_ssl}{Boolean to control if SSL should be verified or not.
Default is FALSE.}

\item{verbose}{A logical value indicating whether to print detailed messages.
Default is TRUE.}

\item{...}{Any other arguments to be supplied to \code{req_option} and thus to \code{libcurl}.}
}
\value{
A data frame containing the queried tetramer data in CSV format.
}
\description{
This function queries the Comparative Toxicogenomics Database API to retrieve
tetramer data based on chemicals, diseases, genes, or other categories.
}
\examples{
\donttest{
tetramer_data <- extr_tetramer(
  chem = c("50-00-0", "ethanol"),
  disease = "",
  gene = "",
  go = "",
  input_term_search_type = "directAssociations",
  qt_match_type = "equals"
)
str(tetramer_data)
}
}
\references{
\itemize{
\item Comparative Toxicogenomics Database: \url{http://ctdbase.org}
\item Davis, A. P., Grondin, C. J., Johnson, R. J., Sciaky, D., McMorran, R.,
Wiegers, T. C., & Mattingly, C. J. (2019).
The Comparative Toxicogenomics Database: update 2019. Nucleic acids research,
47(D1), D948–D954. \doi{10.1093/nar/gky868}
\item Davis, A. P., Wiegers, T. C., Wiegers, J., Wyatt, B., Johnson,
R. J., Sciaky, D., Barkalow, F., Strong, M., Planchart, A.,
& Mattingly, C. J. (2023). CTD tetramers: A new online tool that computationally
links curated chemicals, genes, phenotypes, and diseases to inform molecular
mechanisms for environmental health. Toxicological Sciences, 195(2), 155–168.
\doi{10.1093/toxsci/kfad069}
}
}
\seealso{
\href{http://ctdbase.org}{Comparative Toxicogenomics Database}
}
