% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoway_simultesting.R
\name{twoway_simulation_testing}
\alias{twoway_simulation_testing}
\title{Calculate power for global main effects and interaction from two-way factorial simulated data}
\usage{
twoway_simulation_testing(data, test = "ANOVA", alpha = 0.05)
}
\arguments{
\item{data}{\itemize{
\item Simulation obtained from the 'twoway_simulation_independent' or the 'twoway_simulation_correlated' functions.
}}

\item{test}{\itemize{
\item The test to be applied. Possible values are "ANOVA" (default), "rank" and "permutation".
}}

\item{alpha}{\itemize{
\item Type I error rate. Default is 0.05.
}}
}
\value{
A data.frame with the power and 95\% confidence interval for each of the main effects and their interaction.
}
\description{
This functions takes the output of either the 'twoway_simulation_independent' or the 'twoway_simulation_correlated' functions
and calculates the power of the sample size used in the simulation under parametric analysis of variance, rank based analysis of variance or
permutation testing.
}
\examples{

## After creating a 'matrices_obj' with the 'calculate_mean_matrix' function.

refmean <- 1
treatgroups <- 4
timepoints <- 5
treateff <- 1.5
timeeff <- 0.85
rho <- 0.8
withinf <- "fB"
factors_levels_names <- list(treatment=letters[1:treatgroups], time=1:timepoints)

effects_treat_time <- calculate_mean_matrix(refmean = refmean,
                                            fAeffect = treateff, fBeffect = timeeff,
                                            nlfA = treatgroups,  nlfB = timepoints,
                                            rho = rho, withinf = withinf,
                                            label_list = factors_levels_names)

n <- 7
correlated_sim <- twoway_simulation_correlated(group_size=n, matrices_obj=effects_treat_time,
                  nsims=20)
##used smaller number of iterations to reduce computation time

twoway_simulation_testing(correlated_sim)
## defaults to parametric analysis of variance

twoway_simulation_testing(correlated_sim, test="rank")
## rank based analysis of variance

## permutation test is another option


}
