% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.R
\name{t2norm}
\alias{t2norm}
\alias{approx_binom2norm}
\alias{approx_clt2norm}
\alias{approx_t2norm}
\alias{binom2norm}
\alias{clt2norm}
\title{Distribution Approximations}
\usage{
t2norm(n, c = getOption("distribution.t2norm", 30))

binom2norm(
  size,
  prob,
  c = getOption("distribution.binom2norm", 9),
  type = c("single", "double")
)

clt2norm(n, c = getOption("distribution.clt2norm", 30))

approx_binom2norm(
  size,
  prob,
  c = getOption("distribution.binom2norm", 9),
  type = c("single", "double")
)

approx_clt2norm(n, c = getOption("distribution.clt2norm", 30))

approx_t2norm(n, c = getOption("distribution.t2norm", 30))
}
\arguments{
\item{n}{integer: number of observations (for \code{t2norm} and \code{clt2norm})}

\item{c}{numeric: threshold parameter for approximation (default via \code{getOption()} or a default value)}

\item{size}{integer: number of trials (for \code{binom2norm})}

\item{prob}{numeric: probability of success on each trial (for \code{binom2norm})}

\item{type}{character: approximation type, \code{"single"} or \code{"double"} (for \code{binom2norm})}
}
\value{
logical: \code{TRUE} if the approximation is valid, \code{FALSE} otherwise
}
\description{
These functions check whether a normal approximation is appropriate for a given distribution.
They return \code{TRUE} if the approximation condition is met, and \code{FALSE} otherwise.
The threshold parameter \code{c} can be set directly or retrieved via \code{getOption()}.

The functions apply the following rules:
\itemize{
\item \code{t2norm}: \code{n > c} with default \code{c = 30}.
\item \code{binom2norm}:
\itemize{
\item If \code{type = "single"} (default), the approximation is valid if \verb{size × prob × (1 - prob) > c}.
\item If \code{type = "double"}, the approximation requires both \verb{size × prob > c} and \verb{size × (1 - prob) > c}, with default \code{c = 9}.
}
\item \code{clt2norm}: \code{n > c} with default \code{c = 30}. Note that the existence of expectation and variance, required by the Central Limit Theorem, cannot be checked automatically.
}
}
\examples{
# Check for 5 and 50 observations
t2norm(n = c(5, 50))
binom2norm(size = c(5, 50), prob = 0.5)
binom2norm(size = c(5, 50), prob = 0.5, type = "double")
}
