% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_e2m.R
\name{html_e2m}
\alias{html_e2m}
\alias{toHTML_XML}
\title{HTML \code{exams.forge}}
\usage{
html_e2m(
  exam,
  name = NULL,
  pattern = ".",
  mathjax = TRUE,
  browseURL = TRUE,
  overwrite = FALSE,
  header = 2,
  merge = list(questionlist = "<br>"),
  png = TRUE
)

toHTML_XML(
  exam,
  name = NULL,
  pattern = ".",
  mathjax = TRUE,
  browseURL = TRUE,
  overwrite = FALSE,
  header = 2,
  merge = list(questionlist = "<br>"),
  png = TRUE
)
}
\arguments{
\item{exam}{list: returns a list from \code{exams.forge}}

\item{name}{character: name of the HTML file (default: \code{NULL})}

\item{pattern}{character: string containing a regular expression to match the list elements (default: \code{.})}

\item{mathjax}{logical: should MathJax be loaded? (default: \code{TRUE})}

\item{browseURL}{logical: should the generated HTML be shown? (default: \code{TRUE})}

\item{overwrite}{logical: should the HTML file be overwritten (if it exists)? (default: \code{FALSE})}

\item{header}{integer: at which level of the list a \code{<h2>...</h2>} element should be included? (default: \code{2})}

\item{merge}{list: should elements with \code{.XXXXnn} at the end be merged? (default: \code{list('questionlist'="<br>")})}

\item{png}{logical: if a entry ends with \code{.png} then the function will try to embed the PNG in the output}
}
\value{
Invisibly, the names of listed elements in the HTML file.
}
\description{
Creates an HTML page with all the contents of the XML tags whose names match \code{pattern}.\cr\cr
The default is to show the contents of all XML tags. The HTML page is stored in the HTML file \code{name}.\cr\cr
The default \code{name=NULL} creates a temporary file. If the name does not end in \code{.html}, then a \code{.html} is appended.

If \code{browseURL=TRUE} (default) then the HTML page will be displayed in the browser.

If necessary the contents of XML tags are concatenated with \code{"\n"}.
For single XML tags this can be changed, e.g. \code{merge=list("questionlist"="<br>"} leads to the XML tag
\code{<questionlist>...</questionlist>)} \code{"<br>"} being used ,instead of the \code{"\n"}.
}
\examples{
if (interactive()) {
  resexams <- readRDS(system.file("xml", "klausur-test.rds", package="exams.moodle"))
  html_e2m(resexams) # opens HTML file into browser
}
}
\seealso{
The aim is similar to \code{exams:::exams:::browse_exercise}, however, \code{html_e2m} takes the information form
the XML file generated by the \code{exams.forge} package.
}
