% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affix.R
\name{affix}
\alias{affix}
\alias{add_affix}
\alias{add_math}
\alias{lmath}
\alias{add_bracket}
\alias{brkt}
\alias{add_cdata}
\alias{remove_affix}
\alias{remove_quotes}
\alias{remove_cdata}
\alias{math}
\alias{bracket}
\alias{unaffix}
\alias{unquote}
\alias{uncdata}
\alias{cdata}
\title{Quote and Prefix and/or Suffix Manipulation}
\usage{
affix(txt, prefix = "", suffix = "")

math(txt)

bracket(txt)

unaffix(txt, prefix = "", suffix = "")

unquote(txt)

uncdata(txt)

cdata(txt)

add_affix(txt, prefix = "", suffix = "")

add_cdata(txt)

add_math(txt)

lmath(txt)

add_bracket(txt)

brkt(txt)

remove_affix(txt, prefix = "", suffix = "")

remove_quotes(txt)

remove_cdata(txt)
}
\arguments{
\item{txt}{vector: (character) vector to add a prefix and/or a suffix}

\item{prefix}{character: prefix to add or delete (default: \code{""})}

\item{suffix}{character: suffix to add or delete (default: \code{""})}
}
\value{
a character vector
}
\description{
\code{affix} adds a prefix and/or a suffix to a (character) vector

\code{math} adds a \code{$} as pre- and suffix to a (character) vector

\code{bracket} adds a \code{(} as prefix and \code{)} as suffix to a (character) vector

\code{unaffix} deletes a pre- and/or suffix to a (character) vector

\code{unquote} deletes double quotes at the beginning and the ending of a (character) vector

\code{uncdata} deletes a \code{<![CDATA[} as prefix and \code{]]>} as suffix

\code{cdata} adds a \code{<![CDATA[} as prefix and \code{]]>} as suffix
}
\examples{
x <- runif(5)
affix(x, "$", "$")
math(x)
}
