% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_record_api.R
\name{query_record_api}
\alias{query_record_api}
\title{Query Record API}
\source{
https://pro.europeana.eu/page/record
}
\usage{
query_record_api(id, path = "/record/v2", ...)
}
\arguments{
\item{id}{string with the `RECORD_ID` in the form of `/DATASET_ID/LOCAL_ID`}

\item{path}{string that indicates version of the API}

\item{...}{other parameters passed as query parameters}
}
\value{
S3 object of class `europeana_record_api`. Contains the parsed content,
the path, and the API response compatible with `httr` methods.
}
\description{
The Record API provides direct access to the Europeana data,
which is modeled using the Europeana Data Model (EDM). While EDM is an open
flexible data model featuring various kind of resources and relations
between them, the Record API (and the Europeana Collections Portal) supports
the retrieval of a segment of EDM for practical purposes.

These "atomic" EDM segments typically contain one Cultural Heritage Object
(CHO), aggregation information that connects the metadata and digital
representations, and a number of contextual resources related to the CHO,
such as agents, locations, concepts, and time.
}
\examples{
\dontshow{if (Sys.getenv("EUROPEANA_KEY") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
#set your API key with set_key(api_key = "XXXX")
#query search API
res <- query_search_api("arioch", qf = "1712", media = TRUE)
#get results in tidy format
dat <- tidy_search_items(res)
#query records API for each item
lapply(dat$id, query_record_api)
}
\dontshow{\}) # examplesIf}
}
\references{
\insertRef{doerr2010europeana}{europeanaR}

\insertRef{httr}{europeanaR}

\insertRef{jsonlite}{europeanaR}
}
