% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nivel.confianza.R
\encoding{UTF-8}
\name{nivel.confianza}
\alias{nivel.confianza}
\title{Nivel de confianza.}
\usage{
nivel.confianza(
  min.pob = 2000,
  max.pob = 45000,
  muestras = 200,
  n = 100,
  confianza = 0.95,
  grafico = TRUE,
  exportar = FALSE,
  replicar = FALSE
)
}
\arguments{
\item{min.pob}{Es un valor numérico que indica el valor mínimo poblacional. Por defecto \code{min.pob = 2000}}

\item{max.pob}{Es un valor numérico que indica el valor máximo poblacional. Por defecto \code{max.pob = 45000}}

\item{muestras}{Es un valor numérico entre 50 y 10000 que indica el número de muestras que se extraen sin reemplazamiento de la población. Por defecto \code{muestras = 200}}

\item{n}{Es un valor numérico entre 25 y 2000 que indica el tamaño de la muestra. Por defecto \code{n = 100}}

\item{confianza}{Es un valor numérico entre 0 y 1. Indica el nivel de confianza. Por defecto, \code{confianza = 0.95} (95 por ciento)}

\item{grafico}{Si \code{grafico = TRUE} se representan los intervalos de confianza de las muestras seleccionadas y la media poblacional.}

\item{exportar}{Para exportar los resultados a una hoja de cálculo Excel (\code{exportar = TRUE}).}

\item{replicar}{Es un valor lógico. Si \code{replicar = TRUE} el usuario fijará una semilla para que los resultados sean reproducibles. Si \code{replicar = FALSE} los resultados serán aleatorios y cambiarán en cada realización.}
}
\value{
Esta función devuelve un gráfico como un objeto de la clase \code{list}. La lista contiene los valores simulados para las muestras, el porcentaje de intervalos que contienen la media poblacional y su representación gráfica.
}
\description{
Esta función simula una población de tamaño 100,000 de la que se extraen diversas muestras y construye los correspondientes intervalos de confianzas. El objetivo es transmitir el concepto de nivel de confianza.
}
\note{
Si se seleccionan 10000 muestras de tamaño 2000, el tiempo estimado de ejecución es de 9 minutos.
}
\references{
Casas José M. () Inferencia estadística. Editoral: Centro de estudios Ramón Areces, S.A. ISBN: 848004263-X

Esteban García, J. et al. (2008). Curso básico de inferencia estadística. ReproExprés, SL. ISBN: 8493036595.

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034
}
\seealso{
\code{\link{ic.media}}
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

\strong{Cristina Pardo-García}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
