% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_interpolate.R
\name{signal_interpolate}
\alias{signal_interpolate}
\title{Interpolate a signal vector}
\usage{
signal_interpolate(data, n, l = 4, ...)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{n}{\code{Numeric} value, number of samples to be interpolated by. 
Must be an integer value greater than 1. Default is  \code{2}.}

\item{l}{\code{Character} value, FIR filter length. For  details see 
documentation of \code{signal::decimate}. Default is \code{4}.}

\item{\dots, }{further arguments passed to \code{signal::interp}. See 
details.}
}
\value{
Interpolated data set.
}
\description{
The signal vector \code{data} is interpolated by an integer factor 
\code{n}. If an \code{eseis} object is provided, the meta data is updated. 
The function is a wrapper for the function \code{interp} of the package 
\code{signal}. Note that interpolation does not create new meaningful 
information but rather artefacts above the initial frequency range.
}
\details{
The function calls the function \code{signal::interp} and wraps the output
into the eseis object structure. The ...-argument may contain the passed 
argument \code{Wc} (FIR filter cutoff frequency). Note that by convention 
the argument \code{n} of \code{eseis::signal_interpolate} does not equal the
argument \code{n} of \code{signal::interp}. Rather this is the argument 
\code{l} that is passed as \code{n}.
}
\examples{

## load example data set
data(rockfall)

## detrend data set
s <- signal_detrend(data = rockfall_eseis)

## interpolate by factor 2
s_int = signal_interpolate(data = s, n = 2)

## calculate and plot spectrogram
p_int = signal_spectrogram(data = s_int)
plot(p_int)

}
\author{
Michael Dietze
}
\keyword{eseis}
