% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmConstraint.R
\name{fixedas-ergmConstraint}
\alias{fixedas-ergmConstraint}
\alias{InitErgmConstraint.fixedas}
\title{Fix specific dyads}
\usage{
# fixedas(fixed.dyads, present, absent)
}
\arguments{
\item{fixed.dyads, present, absent}{a two-column edge list or a \code{\link[network:network]{network}}}
}
\description{
Fix the dyads in \code{fixed.dyads} at their current value, preserve the edges in \code{present}, and preclude the edges in \code{absent}.
}
\details{
\code{present} and \code{absent} differ from \code{fixed.dyads} in that
they check that the specified edges are in fact present and/or
absent and stop with an error if not.
}
\seealso{
\code{\link{ergmConstraint}} for index of constraints and hints currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmConstraint", "fixedas", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{undirected}
