% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.coincidence.R
\name{coincidence-ergmTerm}
\alias{coincidence-ergmTerm}
\alias{InitErgmTerm.coincidence}
\title{Coincident node count for the second mode in a bipartite (aka two-mode) network}
\usage{
# binary: coincidence(levels=NULL,active=0)
}
\arguments{
\item{levels}{specifies which pairs of nodes in mode two to include. (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}

\item{active}{selects pairs for which the observed count is at least \code{active} . Ignored if \code{levels} is
specified. (Thus, indices passed as \code{levels} should correspond to indices when \code{levels} = NULL and \code{active} = 0.)}
}
\description{
By default this term adds one
network statistic to the model for each pair of nodes of mode two. It is
equal to the number of (first mode) mutual partners of that pair.
The first mode of a bipartite
network object is sometimes known as the "actor" mode and the seconds as the "event" mode. So this is the number of actors going to both events in the pair. This term can only be
used with undirected bipartite networks.
}
\note{
\pkg{ergm} versions 3.9.4 and earlier used different arguments for this
term. See \code{\link{ergm-options}} for how to invoke the old behaviour.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "coincidence", "subsection")}
}
\concept{bipartite}
\concept{undirected}
