% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{triangle-ergmTerm}
\alias{triangle-ergmTerm}
\alias{InitErgmTerm.triangle}
\alias{triangles-ergmTerm}
\title{Triangles}
\usage{
# binary: triangle(attr=NULL, diff=FALSE, levels=NULL)

# binary: triangles(attr=NULL, diff=FALSE, levels=NULL)
}
\arguments{
\item{attr, diff}{quantitative attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.) If \code{attr} is specified and \code{diff} is \code{FALSE} ,
then the count is restricted to those triples of nodes with
equal values of the vertex attribute specified by \code{attr} . If \code{attr} is specified and \code{diff} is \code{TRUE} ,
then one statistic is added for each value of \code{attr} ,
equal to the number of triangles where all three nodes have that value of the attribute.}

\item{levels}{this optional argument controls which levels of the attribute should be included and which should be excluded. (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}
}
\description{
By default, this term adds one statistic to the model equal to the number of triangles
in the network. For an undirected network, a triangle is defined to be any
set \eqn{\{(i,j), (j,k), (k,i)\}} of three edges. For a directed network, a
triangle is defined as any set of three edges \eqn{(i{\rightarrow}j)}{(i,j)}
and \eqn{(j{\rightarrow}k)}{(j,k)} and either \eqn{(k{\rightarrow}i)}{(k,i)}
or \eqn{(k{\leftarrow}i)}{(i,k)} . The former case is called a "transitive
triple" and the latter is called a "cyclic triple", so in the case of a
directed network, \code{triangle} equals \code{ttriple} plus \code{ctriple}
--- thus at most two of these three terms can be in a model.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "triangle", "subsection")}
}
\concept{categorical nodal attribute}
\concept{directed}
\concept{frequently-used}
\concept{triad-related}
\concept{undirected}
